Attribute VB_Name = "StringMethods"
Option Explicit

Public Function ReadText(FileName As String) As String
    On Error Resume Next
    Open FileName For Input As #1
        If Err Then
            ReadText = ""
            MsgBox "An error occured while reading " & FileName
            Exit Function
        End If
        ReadText = StrConv(InputB(LOF(1), 1), vbUnicode)
    Close #1
End Function

Public Function PathFromFile(T As String) As String
    Static I As Long
    Static CurrentChar As String
    For I = Len(T) To 1 Step -1
        CurrentChar = Mid(T, I, 1)
        If CurrentChar = "/" Or CurrentChar = "\" Then
            PathFromFile = Mid(T, 1, I - 1)
            Exit Function
        End If
    Next I
End Function

Public Function ExtensionFromFile(ByVal T As String) As String
    Static I As Long
    Static NewChar As String
    ExtensionFromFile = ""
    For I = Len(T) To 1 Step -1
        NewChar = Mid(T, I, 1)
        If NewChar = "." Then
            Exit Function
        Else
            ExtensionFromFile = NewChar & ExtensionFromFile
        End If
    Next I
End Function

'Iff A starts with B
'   StartsWith("Abcdef","Ab") -> true
'   StartsWith("Ab","Abcdef") -> false
Public Function StartsWith(A As String, B As String) As Boolean
    If Len(A) > Len(B) Then
        StartsWith = (Left(A, Len(B)) = B)
    Else
        StartsWith = False
    End If
End Function

'Iff A ends with B
'   EndsWith("Abcdef","def") -> true
'   EndsWith("Abcdef","Abc") -> false
Public Function EndsWith(A As String, B As String) As Boolean
    If Len(A) > Len(B) Then
        EndsWith = (Right(A, Len(B)) = B)
    Else
        EndsWith = False
    End If
End Function

Public Function RemoveFrontSpaces(T As String) As String
    Static I As Long
    Static NewChar As String
    Static Started As Boolean
    RemoveFrontSpaces = ""
    Started = False
    For I = 1 To Len(T)
        NewChar = Mid(T, I, 1)
        If NewChar <> " " Then Started = True
        If NewChar <> " " Or Started Then RemoveFrontSpaces = RemoveFrontSpaces & NewChar
    Next I
End Function

Public Function RemoveBackSpaces(T As String) As String
    Static I As Long
    Static NewChar As String
    Static Started As Boolean
    RemoveBackSpaces = ""
    Started = False
    For I = Len(T) To 1 Step -1
        NewChar = Mid(T, I, 1)
        If NewChar <> " " Then Started = True
        If NewChar <> " " Or Started Then RemoveBackSpaces = NewChar & RemoveBackSpaces
    Next I
End Function

Public Function RemoveOutterSpaces(T As String) As String
    RemoveOutterSpaces = RemoveBackSpaces(RemoveFrontSpaces(T))
End Function

Public Function FirstWord(T As String) As String
    Static I As Long
    Static NewChar As String
    FirstWord = ""
    For I = 1 To Len(T)
        NewChar = Mid(T, I, 1)
        If NewChar = " " Then Exit Function
        FirstWord = FirstWord & NewChar
    Next I
End Function

Public Function DotToDecimal(ByVal T As String) As String
    Static I As Long
    Static NewChar As String
    DotToDecimal = ""
    For I = 1 To Len(T)
        NewChar = TakeChar(T, I)
        If NewChar = "." Then
            DotToDecimal = DotToDecimal & ","
        Else
            DotToDecimal = DotToDecimal & NewChar
        End If
    Next I
End Function

Public Function WithoutCInT(ByVal C As String, ByVal T As String) As String
    Static I As Long
    Static NewChar As String
    WithoutCInT = ""
    For I = 1 To Len(T)
        NewChar = TakeChar(T, I)
        If NewChar <> C Then
            WithoutCInT = WithoutCInT & NewChar
        End If
    Next I
End Function

Public Function FromTo(ByVal T As String, ByVal L As Long, ByVal R As Long)
    On Error GoTo BadInput
    FromTo = Mid(T, L, R - L + 1)
    Exit Function
BadInput:
    FromTo = ""
    MsgBox "Error in FromTo:" & vbNewLine & """" & T & """" & vbNewLine & "Start = " & L & vbNewLine & "End = " & R & vbNewLine
End Function

Public Function TakeChar(ByVal T As String, ByVal P As Long)
    If P < 1 Or P > Len(T) Then
        TakeChar = " "
    Else
        TakeChar = Mid(T, P, 1)
    End If
End Function

'The start place of the first Word in T
Public Function GetFirstWord(ByVal Word As String, ByVal T As String, ByVal Start As Long) As Long
    GetFirstWord = Start
    Do
        If Mid(T, GetFirstWord, Len(Word)) = Word Then
            Exit Function
        ElseIf GetFirstWord + (Len(Word) - 1) > Len(T) Then
            GetFirstWord = -1
            Exit Function
        End If
        GetFirstWord = GetFirstWord + 1
    Loop
End Function

'The place of the first C in T
Public Function GetFirst(ByVal C As String, ByVal T As String, ByVal Start As Long) As Long
    If Len(C) <> 1 Then MsgBox "GetFirst: C must be one character"
    GetFirst = Start
    Do
        If TakeChar(T, GetFirst) = C Then
            Exit Function
        ElseIf GetFirst > Len(T) Then
            GetFirst = -1
            Exit Function
        End If
        GetFirst = GetFirst + 1
    Loop
End Function

'The place of the last C in T
Public Function GetLast(ByVal C As String, ByVal T As String, ByVal Start As Long) As Long
    If Len(C) <> 1 Then MsgBox "GetLast: C must be one character"
    GetLast = Start
    Do
        If TakeChar(T, GetLast) = C Then
            Exit Function
        ElseIf GetLast < 1 Then
            GetLast = -1
            Exit Function
        End If
        GetLast = GetLast - 1
    Loop
End Function

