Attribute VB_Name = "EngineShell"

'This module is a simplifying syntax shell for David Piuva's graphics engine.
'By only using simple datatypes in the ActiveX interface, more languages are supported.

'Whenever a new method in the engine have complicated ways to get called, make
'  your own method in you own shell module for easy upgrading.
'Remember to replace frmMain.DGE with whatever your window and engine instance is called.

Option Explicit

'Break and show error messages from the graphics engine
'This should be placed after every call to the engine that can give error messages so that the application will break in debug mode when an error has occured.
'It will continue to break on each point until the error message is deleted by reading it.
'   String buffer methods don't give error messages because they are used to show the message.
'   Matrix buffer methods don't have any preconditions.
Public Sub RE()
    Static Messages As String
    Do While frmMain.DGE.Message_GetCount > 0
        frmMain.DGE.Message_GetContent_OutSB
        frmMain.txtErrors = frmMain.txtErrors & GetStringFromEngine & vbNewLine
    Loop
End Sub

Public Sub InsertStringToEngine(T As String)
    Static I As Long
    frmMain.DGE.SetLengthOfStringBuffer Len(T)
    For I = 1 To Len(T)
        frmMain.DGE.WriteToStringBuffer I, Asc(Mid(T, I, 1))
    Next I
End Sub

Public Function GetStringFromEngine() As String
    Static I As Long
    GetStringFromEngine = ""
    For I = 1 To frmMain.DGE.GetLengthOfStringBuffer
        GetStringFromEngine = GetStringFromEngine & Chr(frmMain.DGE.ReadFromStringBuffer(I))
    Next I
End Function

Public Function StartEngine() As Boolean
    StartEngine = frmMain.DGE.Engine_Initiate: RE
End Function

'Loads a sound from FileName.
Public Function LoadSound(Filename As String, NumberOfCopies As Long, LoadAs3DSound As Boolean, LoadAsEditable As Boolean) As Long
    InsertStringToEngine Filename
    LoadSound = frmMain.DGE.Sound_Buffer_LoadFromFile_InSB(NumberOfCopies, LoadAs3DSound, LoadAsEditable): RE
End Function
