﻿
Option Explicit

'A component for drawing the world
Friend Class Comp_Surface
	Inherits Comp_Abstract
	
	Dim DrawSurface_Target As Integer
	Dim DrawSurface_Result As Integer
	Friend CameraRef As Integer
	
	Friend Overrides Sub Draw(Active As Boolean, OutputDrawSurface As Integer)
		Dim I As Integer
		Dim Color As Vector3
		If DrawSurface_Target <> 0 Then
			If CameraRef <> 0 and Not(World is Nothing) Then
				'Render the world
				If frmMain.DGE.Camera_IsOrthogonal(CameraRef) Then 'Orthogonal
					'Background
					frmMain.DGE.DrawSurface_FillWithColor(DrawSurface_Result, 0, 0, 0, 1) : RE()
					
					'Not selected items
					For I = 0 to World.Items.Count - 1
						If I = HoverItem Then
							'Highlighted
							Color = MakeVector3(1, 1, 1)
						Else
							If World.Items(I).Locked Then
								Color = MakeVector3(0.4, 0.4, 0.4)
							Else
								Color = MakeVector3(0.0, 0.7, 0.7)
							End If
						End If
						If Not(World.Items(I).GetSelected()) Then
							'Wire
							frmMain.DGE.Camera_RenderInstance(CameraRef, DrawSurface_Result, World.Items(I).InstanceRef, MaterialShader_FixedWireFrame, 1, 2, False, Color.x, Color.y, Color.z, 1, -1) : RE()
						End If
					Next I
					
					'Selected items
					For I = 0 to World.Items.Count - 1
						If I = HoverItem Then
							'Highlighted
							Color = MakeVector3(0.5, 1, 0.5)
						Else
							Color = MakeVector3(0.4, 0.7, 0.4)
						End If
						If World.Items(I).GetSelected() Then
							'Wire
							frmMain.DGE.Camera_RenderInstance(CameraRef, DrawSurface_Result, World.Items(I).InstanceRef, MaterialShader_FixedWireFrame, 1, 2, False, Color.x, Color.y, Color.z, 1, -1) : RE()
							'Surface
							frmMain.DGE.Camera_RenderInstance(CameraRef, DrawSurface_Result, World.Items(I).InstanceRef, MaterialShader_SimpleColor, 1, 2, False, Color.x, Color.y, Color.z, 0.4, -1) : RE()
						End If
					Next I
				Else 'Perspective
					'Render world as in game
					RenderWorld(DrawSurface_Target, DrawSurface_Result, 1)
				End If
			End If
			
			frmMain.DGE.Draw_GiveInputSurface(0, DrawSurface_Result) : RE()
			DrawRect(OutputDrawSurface, DrawShader_1Tex, Location, 1)
		End If
	End Sub
	
	'Raise the number of iterations when making a high quality rendering
	Friend Sub RenderWorld(ByVal AccumulationDrawSurface As Integer, ByVal OutputDrawSurface As Integer, ByVal Iterations As Integer)
		Dim I As Integer
		'Clear the output surface with black
		frmMain.DGE.DrawSurface_FillWithColor(OutputDrawSurface, 0, 0, 0, 0) : RE()
		For I = 1 to Iterations
			'Adjust the light
			frmMain.DGE.LightSource_ClearShadows()
			frmMain.DGE.LightSource_SetPos(LightSource_Sun, LightSource_Sun_Pos.X + ((Rnd - 0.5) * 0.1), LightSource_Sun_Pos.Y + ((Rnd - 0.5) * 0.1), LightSource_Sun_Pos.Z + ((Rnd - 0.5) * 0.1)) : RE()
			If Iterations > 1 Then
				frmMain.DGE.LightSource_SetDirection(LightSource_Sun, LightSource_Sun_Dir.X, LightSource_Sun_Dir.Y, LightSource_Sun_Dir.Z, Rnd - 0.5, Rnd - 0.5, Rnd - 0.5) : RE()
			Else
				frmMain.DGE.LightSource_SetDirection(LightSource_Sun, LightSource_Sun_Dir.X, LightSource_Sun_Dir.Y, LightSource_Sun_Dir.Z, 0, 1, 0) : RE()
			End If
			
			'Render the world
			frmMain.DGE.Camera_RenderScene(CameraRef, AccumulationDrawSurface, 0) : RE()
			
			'Add to the result
			frmMain.DGE.PostEffect_GiveInputSurface(0, AccumulationDrawSurface, 0) : RE()
			frmMain.DGE.PostEffect_GiveInputVector(0, 1 / Iterations, 1 / Iterations, 1 / Iterations, 1 / Iterations) : RE()
			frmMain.DGE.PostEffect_GiveInputSurface(1, OutputDrawSurface, 0) : RE()
			frmMain.DGE.PostEffect_GiveInputVector(1, 1, 1, 1, 1) : RE()
			frmMain.DGE.PostEffect_RenderShader(OutputDrawSurface, PostEffect_Blend2)
		Next I
	End Sub
	
	Friend Overrides Sub Event_MouseDown(e As AxDFPGELib._DDFPGEEvents_MouseDownEvent)
		
	End Sub
	
	Friend Overrides Sub Event_MouseMove(e As AxDFPGELib._DDFPGEEvents_MouseMoveEvent)
		
	End Sub
	
	Friend Overrides Sub Event_MouseUp(e As AxDFPGELib._DDFPGEEvents_MouseUpEvent)
		
	End Sub
	
	Friend Overrides Sub Resize()
		If DrawSurface_Target > 0 Then
			frmMain.DGE.DrawSurface_Delete(DrawSurface_Target) : RE()
		End If
		If DrawSurface_Result > 0 Then
			frmMain.DGE.DrawSurface_Delete(DrawSurface_Result) : RE()
		End If
		Dim FinalWidth As Integer
		Dim FinalHeight As Integer
		FinalWidth = Min_Int(Rect_GetWidth(Location) * 2, 8192)
		FinalHeight = Min_Int(Rect_GetHeight(Location) * 2, 8192)
		DrawSurface_Target = frmMain.DGE.DrawSurface_CreateFixed(FinalWidth, FinalHeight, 1, False)
		FinalWidth = Min_Int(Rect_GetWidth(Location), 8192)
		FinalHeight = Min_Int(Rect_GetHeight(Location), 8192)
		DrawSurface_Result = frmMain.DGE.DrawSurface_CreateFixed(FinalWidth, FinalHeight, 0, True)
	End Sub
End Class
