﻿
'A component for selecting a tool
Friend Class Comp_Toolbar
	Inherits Comp_Abstract
	
	Friend HoverIndex As Integer
	Friend PressIndex As Integer
	Friend ToolIndex As Integer
	
	Friend Sub InitTools()
		ToolButtons.Clear()
		ToolButtons.Add(New ToolButton(ToolAction.SelectionCursor, "Select", "", IconRect_Cursor))
		ToolButtons.Add(New ToolButton(ToolAction.CreateItem, "Create item", "", IconRect_Create))
		ToolButtons.Add(New ToolButton(ToolAction.MoveSelected, "Move selected", "Drag anywhere in a 2D view to move everything that is selected.", IconRect_Move))
		ToolButtons.Add(New ToolButton(ToolAction.RotateSelected, "Rotate selected", "", IconRect_Rotate))
		'ToolButtons.Add(New ToolButton(ToolAction.ScaleSelected, "Scale selected", "", IconRect_Scale)) 'Scaling is not yet supported
	End Sub
	
	'The visual buttons
	Friend Class ToolButton
		Friend Action As ToolAction
		Friend Name As String
		Friend HelpText As String
		Friend Icon As RectUV
		Friend Sub New(NewAction As ToolAction, NewName As String, NewHelpText As String, NewIcon As RectUV)
			Action = NewAction
			Name = NewName
			HelpText = NewHelpText
			Icon = NewIcon
		End Sub
	End Class
	Friend ToolButtons As New List(Of ToolButton)
	
	Friend Overrides Sub Draw(Active As Boolean, OutputDrawSurface As Integer)
		'Draw the toolbar texture as a background
		frmMain.DGE.Draw_GiveInputSurface(0, Texture_Toolbar) : RE()
		DrawRect(OutputDrawSurface, DrawShader_1Tex, Location, 0)
		
		'Draw darker behind the selected tool
		If ToolIndex > -1 Then
			'frmMain.DGE.Draw_GiveInputColor(0, 0, 0, 0.5) : RE()
			frmMain.DGE.Draw_GiveInputSurface(0, IconAtlas) : RE()
			frmMain.DGE.Draw_GiveInputSourceRectangleUV1(IconRect_Pressed.MinU, IconRect_Pressed.MaxU, IconRect_Pressed.MinV, IconRect_Pressed.MaxV)
			DrawRect(OutputDrawSurface, DrawShader_1Tex, GetButtonLocation(ToolIndex), 1)
		End If
		
		'Draw tool icons
		Dim I As Integer
		For I = 0 to ToolButtons.Count - 1
			Dim Color As Vector4
			If I = ToolIndex Then
				Color = MakeVector4(1, 1, 1, 1)
			ElseIf I = HoverIndex Then
				Color = MakeVector4(0, 1, 0, 0.8)
			Else
				Color = MakeVector4(0, 0.8, 0, 0.8)
			End If
			frmMain.DGE.Draw_GiveInputColor(Color.X, Color.Y, Color.Z, Color.W) : RE()
			frmMain.DGE.Draw_GiveInputSurface(0, IconAtlas) : RE()
			frmMain.DGE.Draw_GiveInputSourceRectangleUV1(ToolButtons(I).Icon.MinU, ToolButtons(I).Icon.MaxU, ToolButtons(I).Icon.MinV, ToolButtons(I).Icon.MaxV)
			DrawRect(OutputDrawSurface, DrawShader_1Tex, GetButtonLocation(I), 1)
		Next I
	End Sub
	
	Private Function GetButtonLocation(Index As Integer) As Rect
		GetButtonLocation = MakeRect(Location.Left + (Index * Toolbar_Height), Location.Top, Location.Left + ((Index + 1) * Toolbar_Height), Location.Bottom)
	End Function
	
	'Postcondition: Returns the index of the only button that (X,Y) is inside or -1 otherwise
	'X,Y is relative to the upper left corner of the graphics enging component in pixels
	Private Function GetButtonIndexFromPoint(X As Integer, Y As Integer) As Integer
		Dim I As Integer
		For I = 0 to ToolButtons.Count - 1
			If Rect_Inside(GetButtonLocation(I), X, Y) Then
				Return I
			End If
		Next I
		Return -1
	End Function
	
	Friend Overrides Sub Event_MouseDown(e As AxDFPGELib._DDFPGEEvents_MouseDownEvent)
		ToolIndex = GetButtonIndexFromPoint(e.x, e.y)
		If ToolIndex > -1 Then
			Tool = ToolButtons(ToolIndex).Action
		End If
	End Sub
	
	Friend Overrides Sub Event_MouseMove(e As AxDFPGELib._DDFPGEEvents_MouseMoveEvent)
		HoverIndex = GetButtonIndexFromPoint(e.x, e.y)
	End Sub
	
	Friend Overrides Sub Event_MouseUp(e As AxDFPGELib._DDFPGEEvents_MouseUpEvent)
		
	End Sub
	
	Friend Overrides Sub Resize()
		
	End Sub
End Class
