﻿
Option Explicit

Friend Structure Rect
	Dim Left As Integer
	Dim Top As Integer
	Dim Right As Integer
	Dim Bottom As Integer
End Structure

Module LayoutManager
	Friend Function MakeRect(NewLeft As Integer, NewTop As Integer, NewRight As Integer, NewBottom As Integer) As Rect
		MakeRect.Left = NewLeft
		MakeRect.Top = NewTop
		MakeRect.Right = NewRight
		MakeRect.Bottom = NewBottom
	End Function
	
	Friend Function Rect_Visible(ByRef R As Rect) As Boolean
		Rect_Visible = (R.Right > R.Left and R.Bottom > R.Top)
	End Function
	
	Friend Function Rect_Inside(ByRef R As Rect, ByVal X As Integer, ByVal Y As Integer) As Boolean
		Rect_Inside = (X >= R.Left and X <= R.Right and Y >= R.Top and Y <= R.Bottom)
	End Function
	
	Friend Function Rect_GetWidth(ByRef R As Rect) As Integer
		Rect_GetWidth = R.Right - R.Left
	End Function
	
	Friend Function Rect_GetHeight(ByRef R As Rect) As Integer
		Rect_GetHeight = R.Bottom - R.Top
	End Function
	
	Friend Sub VerticalSplit_Three(ByVal Parent As Rect, ByRef LeftSide As Rect, ByRef Center As Rect, ByRef RightSide As Rect, byval HalfSplitSize As integer)
		Static LeftBar As Integer
		Static RightBar As Integer
		LeftBar = (Parent.Left * (1 - (1 / 3))) + (Parent.Right * (1 / 3))
		RightBar = (Parent.Left * (1 - (2 / 3))) + (Parent.Right * (2 / 3))
		LeftSide.Top = Parent.top
		LeftSide.Bottom = Parent.Bottom
		LeftSide.Left = Parent.left
		LeftSide.Right = LeftBar - HalfSplitSize
		Center.Top = Parent.top
		Center.Bottom = Parent.Bottom
		Center.Left = LeftBar + HalfSplitSize
		Center.Right = RightBar - HalfSplitSize
		RightSide.Top = Parent.top
		RightSide.Bottom = Parent.Bottom
		RightSide.left = RightBar + HalfSplitSize
		RightSide.Right = Parent.right
	End Sub
	
	Friend Sub VerticalSplit(ByVal Parent As Rect, ByRef LeftSide As Rect, ByRef RightSide As Rect, ByVal Ratio As Single, ByVal Adder As integer, byval HalfSplitSize As integer)
		Static Bar As Integer
		Bar = (Parent.Left * (1 - ratio)) + (Parent.Right * Ratio) + Adder
		LeftSide.Top = Parent.top
		LeftSide.Bottom = Parent.Bottom
		LeftSide.Left = Parent.left
		LeftSide.Right = Bar - HalfSplitSize
		RightSide.Top = Parent.top
		RightSide.Bottom = Parent.Bottom
		RightSide.left = Bar + HalfSplitSize
		RightSide.Right = Parent.right
	End Sub
	
	Friend Sub HorizontalSplit(ByVal Parent As Rect, ByRef TopSide As Rect, ByRef BottomSide As Rect, ByVal Ratio As Single, ByVal Adder As integer, byval HalfSplitSize As integer)
		Static Bar As Integer
		Bar = (Parent.top * (1 - ratio)) + (Parent.bottom * Ratio) + Adder
		TopSide.Top = Parent.top
		TopSide.Bottom = Bar - HalfSplitSize
		TopSide.Left = Parent.left
		TopSide.Right = Parent.Right
		BottomSide.Top = Bar + HalfSplitSize
		BottomSide.Bottom = Parent.Bottom
		BottomSide.left = Parent.left
		BottomSide.Right = Parent.right
	End Sub
	
	Friend Sub ApplyRectToObject(ByVal Obj As object, ByRef Rect As rect, ByVal MinimumWidth As integer, ByVal MinimumHeight As integer)
		Static Width As Integer
		Static Height As Integer
		Obj.Left = Rect.Left
		Obj.Top = Rect.Top
		Width = Rect_GetWidth(Rect)
		Height = Rect_GetHeight(Rect)
		If Width < MinimumWidth then Width = MinimumWidth
		If Height < MinimumHeight then Height = MinimumHeight
		Obj.width = Width
		Obj.height = Height
	End Sub
	
	Friend Sub LimitSize(ByRef Rect As rect, ByVal MaxWidth As Integer, ByVal MaxHeight As Integer)
		If MaxWidth > -1 Then
			Dim Width As Integer
			Width = Rect_GetWidth(Rect)
			If Width > MaxWidth Then
				Rect.Left = Rect.Left + (Width - MaxWidth) / 2
				Rect.Right = Rect.Right - (Width - MaxWidth) / 2
			End If
		End If
		If MaxHeight > -1 Then
			Dim Height As Integer
			Height = Rect_GetHeight(Rect)
			If Height > MaxHeight Then
				Rect.Top = Rect.Top + (Height - MaxHeight) / 2
				Rect.Bottom = Rect.Bottom - (Height - MaxHeight) / 2
			End If
		End If
	End Sub
End Module
