﻿
Friend Class frmLoadModels
	Private Sub frmLoadModels_Load( sender As System.Object,  e As System.EventArgs) Handles MyBase.Load
		UpdateFiles()
		frmMain.LargeUpdate()
	End Sub
	
	Private Sub UpdateFiles()
		lstFiles.Items.Clear()
		Dim DI As New IO.DirectoryInfo(World.FolderPath)
		Dim FolderInformation As IO.FileInfo() = DI.GetFiles()
		Dim FileInformation As IO.FileInfo
		For Each FileInformation In FolderInformation
			Dim Name As String
			Name = ExtensionlessFileName(FileInformation.Name)
			If DetToUpper(FileInformation.Extension) = ".DMF" and World.GetModelIndexByName(Name) = -1 Then
				lstFiles.Items.Add(Name)
			End If
		Next
	End Sub
	
	Private Sub cmdLoadModel_Click(sender As System.Object, e As System.EventArgs) Handles cmdLoadModel.Click
		If lstFiles.SelectedIndex = -1 Then
			MsgBox("Select an unused model to load.")
		Else
			World.AddModel(lstFiles.Items(lstFiles.SelectedIndex))
			UpdateFiles()
			frmMain.LargeUpdate()
		End If
	End Sub
	
	Private Sub cmdReplaceMissing_Click( sender As System.Object,  e As System.EventArgs) Handles cmdReplaceMissing.Click
		If lstMissingModels.SelectedIndex = -1 Then
			MsgBox("Select a missing model to replace.")
		ElseIf lstExistingModels.SelectedIndex = -1 Then
			MsgBox("Select an existing model to replace with. You might have to load the model you want before replacing with it.")
		Else
			Dim I As Integer
			Dim TargetModelIndex As Integer
			Dim SourceModelIndex As Integer
			TargetModelIndex = lstMissingModels.Items(lstMissingModels.SelectedIndex).TheIndex
			SourceModelIndex = lstExistingModels.Items(lstExistingModels.SelectedIndex).TheIndex
			
			'Replace each use of the old model with the new model
			For I = 0 To World.Items.Count - 1
				If World.Items(I).ModelIndex = TargetModelIndex Then
					If World.Items(I).InstanceRef > 0 Then
						frmMain.DGE.Instance_ReplaceModel(World.Items(I).InstanceRef, World.Models(SourceModelIndex).ModelRef) : RE()
					End If
					World.Items(I).ModelIndex = SourceModelIndex
				End If
			Next I
			
			'Remove the missing model's old filename
			World.DeleteModel(TargetModelIndex)
			
			frmMain.LargeUpdate()
		End If
	End Sub
End Class
