﻿
Module Textures
	Friend Texture_Toolbar As Long
		Friend Toolbar_Height As Long
	Friend Texture_2DGrid_8 As Long
	Friend Texture_2DGrid_16 As Long
	Friend Texture_2DGrid_32 As Long
	Friend Texture_2DGrid_64 As Long
	Friend Texture_2DGrid_128 As Long
	Friend FontAtlas_LucidaConsole_10 As Long
		Friend FontTileWidth As Long
		Friend FontTileHeight As Long
	Friend IconAtlas As Long
		Friend IconAtlas_Rows As Long
		Friend IconAtlas_Columns As Long
		Friend IconRect_Cursor As RectUV
		Friend IconRect_Scale As RectUV
		Friend IconRect_Rotate As RectUV
		Friend IconRect_Move As RectUV
		Friend IconRect_Create As RectUV
		Friend IconRect_Pressed As RectUV
	
	Friend Function LoadTexture(Filename As String) As Long
		InsertStringToEngine(Filename)
		LoadTexture = frmMain.DGE.Texture_Load_InSB: RE()
	End Function
	
	Friend Sub Texture_Init()
		'Load textures
		frmMain.DGE.Texture_UseAsDefaultTexture(LoadTexture("Editor_DefaultTexture")): RE()
		Texture_Toolbar = LoadTexture("Toolbar")
			Toolbar_Height = frmMain.DGE.Texture_GetHeight(Texture_Toolbar): RE()
		Texture_2DGrid_8 = LoadTexture("Editor_2DGrid_8")
		Texture_2DGrid_16 = LoadTexture("Editor_2DGrid_16")
		Texture_2DGrid_32 = LoadTexture("Editor_2DGrid_32")
		Texture_2DGrid_64 = LoadTexture("Editor_2DGrid_64")
		Texture_2DGrid_128 = LoadTexture("Editor_2DGrid_128")
		FontAtlas_LucidaConsole_10 = LoadTexture("Editor_FontAtlas_LucidaConsole_10")
			FontTileWidth = frmMain.DGE.Texture_GetWidth(FontAtlas_LucidaConsole_10) / 16: RE()
			FontTileHeight = frmMain.DGE.Texture_GetHeight(FontAtlas_LucidaConsole_10) / 16: RE()
		IconAtlas = LoadTexture("IconAtlas")
			IconAtlas_Rows = frmMain.DGE.Texture_GetWidth(IconAtlas) / 32: RE()
			IconAtlas_Columns = frmMain.DGE.Texture_GetHeight(IconAtlas) / 32: RE()
			IconRect_Cursor = GetRectUVFromIconAtlas(0, 0)
			IconRect_Scale = GetRectUVFromIconAtlas(1, 0)
			IconRect_Rotate = GetRectUVFromIconAtlas(2, 0)
			IconRect_Move = GetRectUVFromIconAtlas(3, 0)
			IconRect_Create = GetRectUVFromIconAtlas(0, 1)
			IconRect_Pressed = GetRectUVFromIconAtlas(1, 1)
	End Sub
	
	Public Function GetRectUVFromIconAtlas(ByVal Column As Integer, ByVal Row As integer) As RectUV
		GetRectUVFromIconAtlas.MinU = Column / IconAtlas_Columns
		GetRectUVFromIconAtlas.MaxU = (Column + 1) / IconAtlas_Columns
		GetRectUVFromIconAtlas.MinV = Row / IconAtlas_Rows
		GetRectUVFromIconAtlas.MaxV = (Row + 1) / IconAtlas_Rows
	End Function
End Module
