
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#include "stdafx.h"
#include "ContactBuffer.h"
#include "Engine/EngineCore.h"

ContactBuffer::ContactBuffer(void)
{

}

ContactBuffer::~ContactBuffer(void) {
	
}

void ContactBuffer::Clear(void) {
	ContactArray.resize(0);
}

ContactResult* ContactBuffer::GetContact(int Index) {
	if (Index < 0 || Index >= ContactArray.size()) {
		// Out of bound
		return NULL;
	} else {
		return &(ContactArray[Index]);
	}
}

btScalar ContactBuffer::addSingleResult(btManifoldPoint& cp,const btCollisionObject* colObj0,int partId0,int index0,const btCollisionObject* colObj1,int partId1,int index1) {
	ContactResult NewContact;
	
	// Get the ID of body A
	RigidBody_Struct* BodyA;
	BodyA = (RigidBody_Struct*)(colObj0->getUserPointer());
	if (BodyA) {
		NewContact.BodyA_ID = BodyA->ID;
	} else {
		NewContact.BodyA_ID = 0;
	}
	
	// Get the ID of body B
	RigidBody_Struct* BodyB;
	BodyB = (RigidBody_Struct*)(colObj1->getUserPointer());
	if (BodyB) {
		NewContact.BodyB_ID = BodyB->ID;
	} else {
		NewContact.BodyB_ID = 0;
	}
	
	// Get collision properties
	NewContact.WorldPos = cp.m_positionWorldOnB;
	NewContact.WorldNormal = cp.m_normalWorldOnB;
	NewContact.Impulse = cp.m_appliedImpulse;
	// If more is used then more have to be added in Physics_GetAllPairSumContactsFromLastStep_OutCB
	
	// Put the new contact in the collection
	ContactArray.push_back(NewContact);
	
	return 0.0f;
}
