// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#include "stdafx.h"

#ifndef DoubleLinkListIsDeclared
#define DoubleLinkListIsDeclared

template <class el>
struct DoubleLinkListBody; // Forward declaration

// This is stored where you want to access the list
// There can be multiple heads using the same relation as long as they are mutually exclusive
template <class el>
struct DoubleLinkListHead {
	DoubleLinkListBody<el>* Head;
	void ResetMemory(void) {
		Head = NULL;
	}
	void Insert(DoubleLinkListBody<el>* Element,el* Content);
	void Remove(DoubleLinkListBody<el>* Element);
};

template <class el>
void DoubleLinkListHead<el>::Insert(DoubleLinkListBody<el>* Element,el* Content) {
	if (!(Element->Included)) { // If the element is not included
		Element->Included = true; // The element is included
		Element->Previous = NULL; // The first element has no previous element
		Element->Next = Head; // Take the previous head as the tail
		Element->Content = Content;
		Head = Element; // Use the new element as the head
	}
}

template <class el>
void DoubleLinkListHead<el>::Remove(DoubleLinkListBody<el>* Element) {
	if (Element->Included) { // If the element belongs to something
		Element->Included = false; // The element is no longer a member
		if (Head == Element) { // If the element is first in this collection
			Head = Element->Next; // The head is replaced by the element's tail
		} else if (Element->Previous) { // If the element has a previous element
			Element->Previous->Next = Element->Next; // The previous element inherits it's next element no matter if it is null
		}
		if (Element->Next) { // If the element has a next element
			Element->Next->Previous = Element->Previous; // The next element inherits it's previous element no matter if it is null
		}
		Element->Next = NULL; // The element have no next element
		Element->Previous = NULL; // The element have no previous element
	}
}

// This is stored in each element
// It can at most declare membership to one list and can therefor not be used for many to many relations
template <class el>
struct DoubleLinkListBody {
	DoubleLinkListBody<el>* Previous;
	DoubleLinkListBody<el>* Next;
	el* Content;
	bool Included;
	void ResetMemory(void) {
		Previous = NULL;
		Next = NULL;
		Content = NULL;
		Included = false;
	}
};

#endif
