// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#include "../stdAfx.h"

#define LoopForward(min,var,max) for(var=min;var<=max;var++)
#define LoopBackward(min,var,max) for(var=max;var>=min;var--)
#define LoopForwardStartAndLength(var,start,length) LoopForward(start,var,((start)+(length))-1)
#define LoopBackwardStartAndLength(var,start,length) LoopBackward(start,var,((start)+(length))-1)
#define LoopForwardLengthFromZero(var,length) LoopForward(0,var,(length)-1)
#define LoopBackwardLengthFromZero(var,length) LoopBackward(0,var,(length)-1)

bool GetBitFromUINT8(unsigned char X, int Index) {
	if (Index < 0 || Index > 7) {
		//printf("GetBitFromUINT8: Index is out of bound.");
		return false;
	}
	return (X & PowerOfTwo_0to15[7 - Index]) > 0;
}

bool GetBitFromUINT16(UINT16 X, int Index) {
	if (Index < 0 || Index > 15) {
		//printf("GetBitFromUINT16: Index is out of bound.");
		return false;
	}
	return (X & PowerOfTwo_0to15[15 - Index]) > 0;
}

void SetBitInUINT8(unsigned char* pX, int Index, bool NewValue) {
	if (Index < 0 || Index > 7) {
		//printf("SetBitInUINT8: Index is out of bound.");
	} else {
		if (NewValue) {
			*pX = *pX | PowerOfTwo_0to15[7 - Index];
		} else {
			*pX = *pX & ~(PowerOfTwo_0to15[7 - Index]);
		}
	}
}

void SetBitInUINT16(UINT16* pX, int Index, bool NewValue) {
	if (Index < 0 || Index > 15) {
		//printf("SetBitInUINT16: Index is out of bound.");
	} else {
		if (NewValue) {
			*pX = *pX | PowerOfTwo_0to15[15 - Index];
		} else {
			*pX = *pX & ~(PowerOfTwo_0to15[15 - Index]);
		}
	}
}

/*
void PrintBitsInUINT8(unsigned char X) {
	int I;
	LoopForwardLengthFromZero(I,8) {
		if ( GetBitFromUINT8(X,I) ) {
			printf("1");
		} else {
			printf("0");
		}
	}
}

void PrintBitsInUINT16(UINT16 X) {
	int I;
	LoopForwardLengthFromZero(I,16) {
		if ( GetBitFromUINT16(X,I) ) {
			printf("1");
		} else {
			printf("0");
		}
	}
}
*/

int FloatToClosestInt(float X) {
	if (X > 0.0f) {
		return (int)(X + 0.5f);
	} else {
		return (int)(X - 0.5f);
	}
}

unsigned char RoundAndClampToByte(float F) {
	int Result;
	Result = (int)(F + 0.5f);
	if (Result < 0) {
		return 0;
	} else if (Result > 255) {
		return 255;
	} else {
		return Result;
	}
}

long MinL(long A, long B) {
	if (A < B) {
		return A;
	} else {
		return B;
	}
}

long MaxL(long A, long B) {
	if (A > B) {
		return A;
	} else {
		return B;
	}
}
