// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

// Constants
const UINT16 PowerOfTwo_0to15[16] = {1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768};
const unsigned char SignificantToSmoothByte[256] = {0,1,3,2,6,7,5,4,12,13,15,14,10,11,9,8,24,25,27,26,30,31,29,28,20,21,23,22,18,19,17,16,48,49,51,50,54,55,53,52,60,61,63,62,58,59,57,56,40,41,43,42,46,47,45,44,36,37,39,38,34,35,33,32,96,97,99,98,102,103,101,100,108,109,111,110,106,107,105,104,120,121,123,122,126,127,125,124,116,117,119,118,114,115,113,112,80,81,83,82,86,87,85,84,92,93,95,94,90,91,89,88,72,73,75,74,78,79,77,76,68,69,71,70,66,67,65,64,192,193,195,194,198,199,197,196,204,205,207,206,202,203,201,200,216,217,219,218,222,223,221,220,212,213,215,214,210,211,209,208,240,241,243,242,246,247,245,244,252,253,255,254,250,251,249,248,232,233,235,234,238,239,237,236,228,229,231,230,226,227,225,224,160,161,163,162,166,167,165,164,172,173,175,174,170,171,169,168,184,185,187,186,190,191,189,188,180,181,183,182,178,179,177,176,144,145,147,146,150,151,149,148,156,157,159,158,154,155,153,152,136,137,139,138,142,143,141,140,132,133,135,134,130,131,129,128};
const unsigned char SmoothToSignificantByte[256] = {0,1,3,2,7,6,4,5,15,14,12,13,8,9,11,10,31,30,28,29,24,25,27,26,16,17,19,18,23,22,20,21,63,62,60,61,56,57,59,58,48,49,51,50,55,54,52,53,32,33,35,34,39,38,36,37,47,46,44,45,40,41,43,42,127,126,124,125,120,121,123,122,112,113,115,114,119,118,116,117,96,97,99,98,103,102,100,101,111,110,108,109,104,105,107,106,64,65,67,66,71,70,68,69,79,78,76,77,72,73,75,74,95,94,92,93,88,89,91,90,80,81,83,82,87,86,84,85,255,254,252,253,248,249,251,250,240,241,243,242,247,246,244,245,224,225,227,226,231,230,228,229,239,238,236,237,232,233,235,234,192,193,195,194,199,198,196,197,207,206,204,205,200,201,203,202,223,222,220,221,216,217,219,218,208,209,211,210,215,214,212,213,128,129,131,130,135,134,132,133,143,142,140,141,136,137,139,138,159,158,156,157,152,153,155,154,144,145,147,146,151,150,148,149,191,190,188,189,184,185,187,186,176,177,179,178,183,182,180,181,160,161,163,162,167,166,164,165,175,174,172,173,168,169,171,170};
const UINT16 ByteMask = 255;

// PreCondition: 0 <= Index < 8
// PostCondition: The bit in X at Index.
// Index is counting from the most significant bit.
bool GetBitFromUINT8(unsigned char X, int Index);

// PreCondition: 0 <= Index < 16
// PostCondition: The bit in X at Index.
// Index is counting from the most significant bit.
bool GetBitFromUINT16(UINT16 X, int Index);

// PreCondition: 0 <= Index < 8, pX != NULL.
// SideEffect: The bit at Index in the integer pointed to by pX is set to NewValue.
// Index is counting from the most significant bit.
void SetBitInUINT8(unsigned char* pX, int Index, bool NewValue);

// PreCondition: 0 <= Index < 16, pX != NULL.
// SideEffect: The bit at Index in the integer pointed to by pX is set to NewValue.
// Index is counting from the most significant bit.
void SetBitInUINT16(UINT16* pX, int Index, bool NewValue);

/*
// SideEffect: Print each bit in X with the most significant bits first.
void PrintBitsInUINT8(unsigned char X);

// SideEffect: Print each bit in X with the most significant bits first.
void PrintBitsInUINT16(UINT16 X);
*/

// Precondition: X must be inside the integer's range
// Postcondition: X rounded to the colsest integer.
// When 2 integers are closest, it choose the integer most away from 0.
int FloatToClosestInt(float X);

// Like FloatToClosestInt but clamped to an unsigned char
unsigned char RoundAndClampToByte(float F);

// Postcondition: The smallest of A and B
long MinL(long A, long B);

// Postcondition: The largest of A and B
long MaxL(long A, long B);
