// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#pragma once

#include "MessageQueue.h"

class ByteArray {
private:
	long UsedBytes;
	long AllocatedBytes;
	long UnusedBits;
	void ResizeAllocation(long NewSize);
	MessageQueue* MQ;
public:
	ByteArray(long InitialUsedSize, MessageQueue* NewMQ);
	~ByteArray(void);
	// Direct access
		unsigned char* TheData;
	// Size methods
		void Resize(long NewUsedSize);
		long GetSizeInBytes(void);
		long GetSizeInBits(void);
		long GetSizeInBits_ExcludingUnusedBits(void);
	// Memory management
		void MakeCopy(ByteArray* Dest);
		bool IsEqual(ByteArray* Reference);
	// Set methods
		void SetByte(long Index, unsigned char NewValue);
		void SetBit(long Index, bool NewValue);
		void SetBitInByte(long ByteOffset, long BitOffset, bool NewValue);
		void InsertByte(unsigned char NewValue);
		void InsertBit(bool NewValue);
		void LeaveUnusedBits(void);
	// Get methods
		unsigned char GetByte(long Index);
		bool GetBit(long Index);
		bool GetBitInByte(long ByteOffset, long BitOffset);
	// Debug methods
		//void PrintContent(void);
	// Compression methods
		void SmoothByte(void); // This will create redundancy without adding or removing any data.
		void SmoothByte_Inverse(void);
		void MakeCopyWithSortedBits(ByteArray* Dest); // This will prepare the bits for run length encoding.
		void MakeCopyWithSortedBits_Inverse(ByteArray* Dest);
		void DeriveInModulo(void); // This will make smooth curves take less space and noise take more space.
		void DeriveInModulo_Inverse(void);
	// Checksum methods
		UINT64 GetCheckSum(void);
};
