
// This header can be used to simplify common code to reduce errors and make the code easier to read.

// If you need another type of for loop, just write another macro for it.
#define LoopForward(min,var,max) for(var=min;var<=max;var++)
#define LoopBackward(min,var,max) for(var=max;var>=min;var--)
#define LoopForwardStartAndLength(var,start,length) LoopForward(start,var,((start)+(length))-1)
#define LoopBackwardStartAndLength(var,start,length) LoopBackward(start,var,((start)+(length))-1)
#define LoopForwardLengthFromZero(var,length) LoopForward(0,var,(length)-1)
#define LoopBackwardLengthFromZero(var,length) LoopBackward(0,var,(length)-1)

// These are from the DirectX SDK
#define SAFE_DELETE(p)       { if (p) { delete (p);     (p)=NULL; } }
#define SAFE_DELETE_ARRAY(p) { if (p) { delete[] (p);   (p)=NULL; } }
#define SAFE_RELEASE(p)      { if (p) { (p)->Release(); (p)=NULL; } }

// {} will prevent dangling else from only taking the first statement
// Remember to check that the parent exist
#define StartUsing(USECOUNTER) \
	{ (USECOUNTER)++; }
#define StopUsing(USECOUNTER) \
	{ \
		(USECOUNTER)--; \
		if (USECOUNTER < 0) { USECOUNTER = 0; MQ->InsertMessage(L"A use counter was negative. Report how you got this error if you found it in the latest version of the graphics engine."); } \
	}
