
// This module has some code taken from d3dx9math.h

#include "../stdafx.h"

#ifndef __D3DX9MATH_H__
#define __D3DX9MATH_H__

#include <math.h>
#if _MSC_VER >= 1200
#pragma warning(push)
#endif
#pragma warning(disable:4201) // anonymous unions warning

//--------------------------
// 2D Vector
//--------------------------
typedef struct DVector2 {
    DVector2() {};
    DVector2( float NewX, float NewY );
    float x, y;
} DVector2, *LPD3DXVECTOR2;

//--------------------------
// 3D Vector
//--------------------------
typedef struct DVector3 {
    DVector3() {};
    DVector3( float NewX, float NewY, float NewZ );
    float x, y, z;
} DVector3, *LPD3DXVECTOR3;

//--------------------------
// 4D Vector
//--------------------------
typedef struct DVector4 {
    DVector4() {};
    DVector4( float NewX, float NewY, float NewZ, float NewW );
    float x, y, z, w;
} DVector4, *LPD3DXVECTOR4;

//===========================================================================
//
// Matrices
//
//===========================================================================

typedef struct DMatrix {
    DMatrix() {};
    DMatrix( float New_11, float New_12, float New_13, float New_14, float New_21, float New_22, float New_23, float New_24, float New_31, float New_32, float New_33, float New_34, float New_41, float New_42, float New_43, float New_44 );

    // casting operators
    operator float* ();
    operator const float* () const;
    union {
        struct {
            float        _11, _12, _13, _14;
            float        _21, _22, _23, _24;
            float        _31, _32, _33, _34;
            float        _41, _42, _43, _44;
        };
        float m[4][4];
    };
} D3DXMATRIX, *LPD3DXMATRIX;

#define V4_TO_V3(V) DVector3(V.x,V.y,V.z)

#define SET_XYZ_IN_V4(V,X,Y,Z) V.x = X; V.y = Y; V.z = Z;

DVector3 BulletToDX_V3(btVector3* V);

float* ToFloatArray(const DVector2* V);

float* ToFloatArray(const DVector3* V);

float* ToFloatArray(const DVector4* V);

DVector2 AddVec2(DVector2 V1, DVector2 V2);

DVector2 SubVec2(DVector2 V1, DVector2 V2);

DVector3 AddVec3(DVector3 V1, DVector3 V2);

DVector3 SubVec3(DVector3 V1, DVector3 V2);

DVector4 AddVec4(DVector4 V1, DVector4 V2);

DVector4 SubVec4(DVector4 V1, DVector4 V2);

DVector2 ScaleVec2(DVector2 V, float S);

DVector3 ScaleVec3(DVector3 V, float S);

DVector4 ScaleVec4(DVector4 V, float S);

float AbsVec3(DVector3 V);

float DistVec3(DVector3 V1, DVector3 V2);

DVector3 NormalizeVec3(DVector3 V);

DVector3 CrossVec3(DVector3 V1, DVector3 V2);

float DotVec3(DVector3 V1, DVector3 V2);

DVector4 Vec3ToVec4(DVector3 V, float W);

float AbsFloat(float X);

float MaxFloat(float A, float B);

float MinFloat(float A, float B);

float ClampFloat(float Min, float X, float Max);

int ClampInt(int Min, int X, int Max);

float Lerp(float A, float B, float Ratio);

float InverseLerp(float A, float B, float Value);

void MakeOrthogonalBtTransform(btTransform* T,DVector3 Pos, DVector3 XAxis, DVector3 YAxis);

DMatrix TransposeMatrix(DMatrix M);

DVector3 TransformVec3Mat4(DVector3 V, DMatrix M);

DVector4 TransformVec4Mat4(DVector4 V, DMatrix M);

DMatrix LookAtLH(DVector3 Eye, DVector3 At, DVector3 Up);

DMatrix OrthoLH(float w, float h, float zn, float zf);

DMatrix PerspectiveFovLH(float fovy, float Aspect, float zn, float zf);

DMatrix MulMat(DMatrix M1, DMatrix M2);

DMatrix IdentityMatrix(void);

#endif // __D3DX9MATH_H__
