
/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#include "../stdafx.h"

#pragma once

class FourChannelHeightField : public btConcaveShape
{
protected:
	btVector3	m_localAabbMin;
	btVector3	m_localAabbMax;
	btVector3	m_localOrigin;
	
	///terrain data
	int	m_heightStickWidth;
	int m_heightStickLength;
	btScalar	m_minHeight;
	btScalar	m_maxHeight;
	btScalar m_width;
	btScalar m_length;
	union
	{
		const unsigned char*	m_heightfieldDataUnsignedChar;
		const short*		m_heightfieldDataShort;
		const btScalar*			m_heightfieldDataFloat;
		const void*	m_heightfieldDataUnknown;
	};
	
	int		m_channelIndex;
	bool	m_flipQuadEdges;
	bool	m_useDiamondSubdivision;
	int		m_upAxis;

	btVector3	m_localScaling;
	
	virtual btScalar	getRawHeightFieldValue(int x,int y) const;
	void		quantizeWithClamp(int* out, const btVector3& point,int isMax) const;
	void		getVertex(int x,int y,btVector3& vertex) const;
	
	/// protected initialization
	/**
	  Handles the work of constructors so that public constructors can be
	  backwards-compatible without a lot of copy/paste.
	 */
	void initialize(
		int heightStickWidth, int heightStickLength, const void* heightfieldData,
		btScalar minHeight, btScalar maxHeight, int upAxis,
		int channelIndex, bool flipQuadEdges, bool diamondPattern
	);

public:
	FourChannelHeightField(int heightStickWidth, int heightStickLength, void* heightfieldData, btScalar minHeight, btScalar maxHeight,int upAxis,int channelIndex, bool flipQuadEdges, bool diamondPattern);
	virtual ~FourChannelHeightField();

	virtual void getAabb(const btTransform& t,btVector3& aabbMin,btVector3& aabbMax) const;

	virtual void	processAllTriangles(btTriangleCallback* callback,const btVector3& aabbMin,const btVector3& aabbMax) const;
	void	processTrianglesAlongLine(btTriangleCallback* callback,const btVector3& lineStart,const btVector3& lineEnd) const;
	void	processQuad(btTriangleCallback* callback,int x,int j) const;

	virtual void	calculateLocalInertia(btScalar mass,btVector3& inertia) const;

	virtual void	setLocalScaling(const btVector3& scaling);
	
	virtual const btVector3& getLocalScaling() const;
	
	//debugging
	virtual const char*	getName()const {return "HEIGHTFIELD";}

};
