
/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#pragma once

#include "Physics_ModifiedCompound.h"
#include "MathMethods.h"

ModifiedCompound::~ModifiedCompound() {
}

ModifiedCompound::ModifiedCompound()
: btCompoundShape()
{

}

// Modification from "dphil" at the Bullet physics forum
// http://bulletphysics.org/Bullet/phpBB3/viewtopic.php?f=9&t=7455&view=previous
void ModifiedCompound::setLocalScaling(const btVector3& scaling) {
	for(int i = 0; i < getNumChildShapes(); i++) {
		btTransform childTrans = getChildTransform(i);
		btVector3 childScale = getChildShape(i)->getLocalScaling();
		childScale = childScale * scaling / m_localScaling;
		getChildShape(i)->setLocalScaling(childScale);
		childTrans.setOrigin(childTrans.getOrigin() * scaling / m_localScaling);
		updateChildTransform(i, childTrans,false);
	}
	m_localScaling = scaling;
	recalculateLocalAabb();
}
