
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#include <windows.h>
#include "../MessageQueue.h"

#pragma once

class PointerArray
{
private:
	void** TheContent;
	float* TheSortValues;
	int Size;
	int LastUsedSize;
	bool Allocated;
	int Heapsize;
	int heapParent(int x);
	int heapLeft(int x);
	int heapRight(int x);
	void maxHeapify(int i);
	void buildMaxHeap(void);
	void swapElements_Unsafe(int A, int B);
	void swapElements_Warning(int A, int B);
public:
	MessageQueue* MQ;
	PointerArray(void) : MQ(NULL), LastUsedSize(0), TheContent(NULL), TheSortValues(NULL), Size(0), Heapsize(0), Allocated(false) {}
	int getLowerBound(void);
	int getUpperBound(void);
	int getSize(void);
	void allocate(int newSize, void* initialValue);
	void redim_erase(int newSize, void* initialValue);
	void redim_preserve(int newSize, void* initialValue);
	void* getValue_warning(int index);
	void setValue_warning(int index, void* newValue);
	void* getValue_padded(int index, void* outsideValue);
	void setValue_ignore(int index, void* newValue);
	float getSortValue_warning(int index);
	void setSortValue_warning(int index, float newSortValue);
	float getSortValue_padded(int index, float outsideSortValue);
	void setSortValue_ignore(int index, float newSortValue);
	void safeSort(int usedSize);
	void heapSort(int usedSize);
	void deallocate(void);
};
