
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#include "../stdafx.h"

#ifndef _SOUNDCLASS_H_
#define _SOUNDCLASS_H_

#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include "../MessageQueue.h"

class SoundClass {
private:
	struct WaveHeaderType {
		char chunkId[4];
		unsigned long chunkSize; // The length of the file in bytes
		char format[4];
		char subChunkId[4];
		unsigned long subChunkSize;
		unsigned short audioFormat;
		unsigned short numChannels;
		unsigned long sampleRate;
		unsigned long bytesPerSecond;
		unsigned short blockAlign;
		unsigned short bitsPerSample;
		char dataChunkId[4];
		unsigned long dataSize; //The length of the real sound content without meta data in bytes
	};
	struct SoundCopy {
		IDirectSoundBuffer8* SecondaryBuffer;
		IDirectSound3DBuffer8* Secondary3DBuffer;
		DVector3 LastAssigned_3DPosition;
		float LastAssigned_Volume;
		float LastAssigned_Speed;
	};
	struct CompressedHeaderType {
		char filetype[4]; // DSF1
		unsigned long sampleRate; // From the wave file header
		unsigned short numChannels; // From the wave file header
		unsigned long size; // The content's length in bytes stored in the ByteArray object
	};
	struct CompressedData {
		CompressedHeaderType Header; // Save this
		ByteArray* Content; // Save this
		ByteArray* ExtraBuffer; // Don't save this
	};
	char* waveData;
	bool LoadWaveFile(wchar_t* Filename);
	bool SaveWaveFile(wchar_t* Filename);
	bool LoadDSF1File(wchar_t* Filename);
	bool SaveDSF1File(wchar_t* Filename);
	long LinearToMillibel(float LinearVolume);
	IDirectSound8* m_pSoundEngineInterface;
	DWORD MinFrequency;
	DWORD MaxFrequency;
	SoundCopy* SoundCollection;
	
	// Scaling
	float MetersPerDistanceUnit;
	
	// Compressing
	long R; // Reading position
	long LastEnd; // Only for error checking
	float NonLinearScale(float X);
	float LinearScale(float X);
	unsigned char FloatToByte(float F);
	float ByteToFloat(unsigned char B);
	void WriteNumber(int TheValue, ByteArray* OutputArray);
	long ReadNumber(ByteArray* InputArray);
	void CreateLoopPackage(long Start, long End, bool Bit, ByteArray* OutputArray);
	void CreateLoopPackages(long Start, long End, bool Bit, ByteArray* OutputArray);
	void CreateRawPackage(long Start, long End, ByteArray* InputArray, ByteArray* OutputArray);
	void CreateRawPackages(long Start, long End, ByteArray* InputArray, ByteArray* OutputArray);
	void RunLengthEncode(ByteArray* InputArray, ByteArray* OutputArray);
	bool RunLengthDecode(ByteArray* InputArray, ByteArray* OutputArray);
	void LosslessEncode(ByteArray* RefArray, ByteArray* ExtraBuffer);
	void LosslessDecode(ByteArray* RefArray, ByteArray* ExtraBuffer);
public:
	// Safety
	MessageQueue* MQ;
	
	// Read only for collecting data about the sound
	WaveHeaderType waveFileHeader;
	
	// Read only flags
	bool	Flag_Loaded;
	int		Flag_NumberOfCopies;
	bool	Flag_IsEditable;
	bool	Flag_3DSound;
	
	// Counters
	int LastPlayedIndex;
	
	//Interface
	SoundClass(IDirectSound8* Engine,HWND Window,wchar_t* Filename,int NewNumberOfCopies, bool LoadAs3DSound, bool Editable, MessageQueue* NewMQ, float NewMetersPerDistanceUnit);
	SoundClass(IDirectSound8* Engine,HWND Window,int SampleRate, int Channels, long SamplesPerChannel,int NewNumberOfCopies, bool LoadAs3DSound, MessageQueue* NewMQ, float NewMetersPerDistanceUnit);
	void ConstructorHelper(IDirectSound8* Engine,HWND Window, bool LoadAs3DSound, bool Editable, MessageQueue* NewMQ, float NewMetersPerDistanceUnit, int NewNumberOfCopies);
	
	~SoundClass();
	bool Play(int Index, bool FromBeginning, bool Looping);
	bool Stop(int Index);
	bool SetVolume(int Index, float Volume);
	bool SetSpeed(int Index, float Speed);
	bool IsPlaying(int Index);
	bool Set3DPosition(int Index, float X, float Y, float Z);
	bool Save(wchar_t* Filename);
	bool Load(wchar_t* Filename);
	float ReadWaveData(int Time, int Channel);
	void WriteWaveData(int Time, int Channel, float NewValue);
	void AllocateNewWaveData(int SampleRate, int Channels, long SamplesPerChannel);
	int GetSampleRate(void);
	int GetNumberOfChannels(void);
	int GetSamplesPerChannel(void);
	float GetSpeed(int Index);
	float GetVolume(int Index);
	void SetMetersPerDistanceUnit(float Meters);
	DVector3 Get3DPosition(int Index);
	bool UpdateBuffers(void);
};

#endif
