
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#include "GlobalConstants.h"

wchar_t* NameFromShaderType(int ShaderType) {
	switch (ShaderType) {
	case ShaderType_Material:
		return L"Material"; break;
	case ShaderType_PostEffect:
		return L"PostEffect"; break;
	case ShaderType_Draw:
		return L"Draw"; break;
	case ShaderType_Line:
		return L"Line"; break;
	default : 
		return L"Unknown"; break;
	}
}

wchar_t* NameFromShapeType(int ShapeType) {
	switch (ShapeType) {
	case ShapeType_Box:
		return L"Box"; break;
	case ShapeType_Sphere:
		return L"Sphere"; break;
	case ShapeType_StaticPlane:
		return L"StaticPlane"; break;
	case ShapeType_Cylinder:
		return L"Cylinder"; break;
	case ShapeType_Capsule:
		return L"Capsule"; break;
	case ShapeType_Cone:
		return L"Cone"; break;
	case ShapeType_HeightField:
		return L"HeightField"; break;
	case ShapeType_Compound:
		return L"Compound"; break;
	case ShapeType_ConvexHull:
		return L"ConvexHull"; break;
	default : 
		return L"Unknown"; break;
	}
}

wchar_t* NameFromConstraintType(int ConstraintType) {
	switch (ConstraintType) {
	case ConstraintType_PointToPoint_1:
		return L"PointToPoint_1"; break;
	case ConstraintType_PointToPoint_2:
		return L"PointToPoint_2"; break;
	case ConstraintType_Hinge_1:
		return L"Hinge_1"; break;
	case ConstraintType_Hinge_2:
		return L"Hinge_2"; break;
	case ConstraintType_Slider_1:
		return L"Slider_1"; break;
	case ConstraintType_Slider_2:
		return L"Slider_2"; break;
	case ConstraintType_ConeTwist_1:
		return L"ConeTwist_1"; break;
	case ConstraintType_ConeTwist_2:
		return L"ConeTwist_2"; break;
	case ConstraintType_6DOF_1:
		return L"6DOF_1"; break;
	case ConstraintType_6DOF_2:
		return L"6DOF_2"; break;
	default : 
		return L"Unknown"; break;
	}
}

wchar_t* NameFromLightType(int LightType) {
	switch (LightType) {
	case LightType_Point:
		return L"Point"; break;
	case LightType_Sun:
		return L"Sun"; break;
	case LightType_Spot:
		return L"Spot"; break;
	case LightType_Spot_Atlas:
		return L"Spot_Atlas"; break;
	case LightType_Spot_Shadow:
		return L"Spot_Shadow"; break;
	case LightType_Spot_Atlas_Shadow:
		return L"Spot_Atlas_Shadow"; break;
	case LightType_Sun_Shadow_SingleLayer:
		return L"Sun_Shadow_SingleLayer"; break;
	default :
		return L"Unknown"; break;
	}
}
