
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#ifndef GLOBAL_CONSTANTS
#define GLOBAL_CONSTANTS

const int Filter_None = 0;
const int Filter_Alpha = 1;
const int NumberOfFilterTypes = 2;

const int Culling_None = 0;
const int Culling_AABB = 1;
const int Culling_Radius = 2;

const int ShaderType_Material = 0;
const int ShaderType_PostEffect = 1;
const int ShaderType_Draw = 2;
const int ShaderType_Line = 3;
const int NumberOfShaderTypes = 4;
wchar_t* NameFromShaderType(int ShaderType);

const int SurfaceType_Empty = 0;
const int SurfaceType_Texture = 1;
const int SurfaceType_DrawSurface = 2;

const int SubresourceType_Color = 0;
const int SubresourceType_Depth = 1;
const int LastSubresourceType = 1;

const int ShapeType_Box = 0;
const int ShapeType_Sphere = 1;
const int ShapeType_StaticPlane = 2;
const int ShapeType_Cylinder = 3;
const int ShapeType_Capsule = 4;
const int ShapeType_Cone = 5;
const int ShapeType_HeightField = 6;
const int ShapeType_Compound = 7;
const int ShapeType_ConvexHull = 8;
wchar_t* NameFromShapeType(int ShapeType);

const int ConstraintType_PointToPoint_1 = 0;
const int ConstraintType_PointToPoint_2 = 1;
const int ConstraintType_Hinge_1 = 2;
const int ConstraintType_Hinge_2 = 3;
// Constraints below are not yet implemented
const int ConstraintType_Slider_1 = 4;
const int ConstraintType_Slider_2 = 5;
const int ConstraintType_ConeTwist_1 = 6;
const int ConstraintType_ConeTwist_2 = 7;
const int ConstraintType_6DOF_1 = 8;
const int ConstraintType_6DOF_2 = 9;
wchar_t* NameFromConstraintType(int ConstraintType);

const int LightType_Point = 0;
const int LightType_Sun = 1;
const int LightType_Spot = 2;
const int LightType_Spot_Atlas = 3;
const int LightType_Spot_Shadow = 4;
const int LightType_Spot_Atlas_Shadow = 5;
const int LightType_Sun_Shadow_SingleLayer = 6;
wchar_t* NameFromLightType(int LightType);

const int NumberOfShaderChannels = 16;
const int NumberOfTextureChannels = 16;
	const int LightProjectionTextureChannel = 16;
	const int DepthAtlasTextureChannel = 17;
	const int DepthCopyTextureChannel = 18;

// The material shader header must have the same dimensions
const int NumberOfUserVectorsPerInstance = 16;
const int NumberOfUserVectorsPerPostEffect = 16;
const int NumberOfUserVectorsPerDrawing = 16;
const int NumberOfUserElementsPerRigidBody = 8;
const int NumberOfOverrideChannels = 16;
const int MaxNumberOfLights = 64;
const int MaxNumberOfBones = 64; // FillInstanceConstantBuffers must be updated with more buffers if it expand

// Rendering method
const int RenderingMethod_Triangles = 0;
const int RenderingMethod_Edges = 1;
const int RenderingMethod_DoubleSidedTriangles = 2;
const int NumberOfRenderingMethods = 3;

// Compilation results
const int CompilationResult_Failed = 0;
const int CompilationResult_Compiled = 1;
const int CompilationResult_OptionalEntryNotFound = 2;

// Power of two bitmasks for activating debug drawing in cameras
// These constants will be shown to the user as a linear range starting from 0
const unsigned short int DebugDraw_WorldCenter = 1;
const unsigned short int DebugDraw_RigidBodies = 2;
const unsigned short int DebugDraw_Constraints = 4;
const unsigned short int DebugDraw_Collisions = 8;
const unsigned short int DebugDraw_Instances = 16;
const int NumberOfDebugDrawFlags = 5; // At most 16 because of the size of the bitmask stored in the camera

#endif
