
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

// Input types
// http://msdn.microsoft.com/en-us/library/04y6h44d%28v=VS.80%29.aspx
#define In_Void			VTS_NONE
#define In_Boolean		VTS_BOOL
#define In_Int16		VTS_I2
#define In_Int32		VTS_I4
#define In_Float32		VTS_R4

// Return types
#define Out_Void		VT_EMPTY
//Never return booleans because the user might compare a true value from a bitmask (4) with a constant for true (1) and think that the result is false.
//	If the user knows that it is an integer then the safety issue is gone.
#define Out_Int16		VT_I2
#define Out_Int32		VT_I4
#define Out_Float32		VT_R4

// C++ types
#define CT_Void			void
#define CT_Boolean		bool
#define CT_Int16		short int
#define CT_Int32		int
#define CT_Float32		float

// CO = C++ output
// OO = Ocx output
// CI = C++ input
// OI = Ocx input

// Header for linktime checking
#define SUBMACRO_HEADER_0(DISPID,OT,FNAME) \
	CT_##OT FNAME(void);
#define SUBMACRO_HEADER_1(DISPID,OT,FNAME,AN1,AT1) \
	CT_##OT FNAME(CT_##AT1 AN1);
#define SUBMACRO_HEADER_2(DISPID,OT,FNAME,AN1,AT1,AN2,AT2) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2);
#define SUBMACRO_HEADER_3(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3);
#define SUBMACRO_HEADER_4(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4);
#define SUBMACRO_HEADER_5(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5);
#define SUBMACRO_HEADER_6(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6);
#define SUBMACRO_HEADER_7(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7);
#define SUBMACRO_HEADER_8(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8);
#define SUBMACRO_HEADER_9(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9);
#define SUBMACRO_HEADER_10(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10);
#define SUBMACRO_HEADER_11(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11);
#define SUBMACRO_HEADER_12(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12);
#define SUBMACRO_HEADER_13(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13);
#define SUBMACRO_HEADER_14(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14);
#define SUBMACRO_HEADER_15(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15);
#define SUBMACRO_HEADER_16(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16);
#define SUBMACRO_HEADER_17(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17);
#define SUBMACRO_HEADER_18(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18);
#define SUBMACRO_HEADER_19(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19);
#define SUBMACRO_HEADER_20(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20);
#define SUBMACRO_HEADER_21(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21);
#define SUBMACRO_HEADER_22(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21,CT_##AT22 AN22);
#define SUBMACRO_HEADER_23(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22,AN23,AT23) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21,CT_##AT22 AN22,CT_##AT23 AN23);
#define SUBMACRO_HEADER_24(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22,AN23,AT23,AN24,AT24) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21,CT_##AT22 AN22,CT_##AT23 AN23,CT_##AT24 AN24);
#define SUBMACRO_HEADER_25(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22,AN23,AT23,AN24,AT24,AN25,AT25) \
	CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21,CT_##AT22 AN22,CT_##AT23 AN23,CT_##AT24 AN24,CT_##AT25 AN25);

// C++ interface
#define SUBMACRO_DISPATCH_0(DISPID,OT,FNAME) \
	[id(DISPID)] CT_##OT FNAME(void);
#define SUBMACRO_DISPATCH_1(DISPID,OT,FNAME,AN1,AT1) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1);
#define SUBMACRO_DISPATCH_2(DISPID,OT,FNAME,AN1,AT1,AN2,AT2) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2);
#define SUBMACRO_DISPATCH_3(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3);
#define SUBMACRO_DISPATCH_4(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4);
#define SUBMACRO_DISPATCH_5(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5);
#define SUBMACRO_DISPATCH_6(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6);
#define SUBMACRO_DISPATCH_7(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7);
#define SUBMACRO_DISPATCH_8(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8);
#define SUBMACRO_DISPATCH_9(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9);
#define SUBMACRO_DISPATCH_10(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10);
#define SUBMACRO_DISPATCH_11(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11);
#define SUBMACRO_DISPATCH_12(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12);
#define SUBMACRO_DISPATCH_13(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13);
#define SUBMACRO_DISPATCH_14(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14);
#define SUBMACRO_DISPATCH_15(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15);
#define SUBMACRO_DISPATCH_16(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16);
#define SUBMACRO_DISPATCH_17(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17);
#define SUBMACRO_DISPATCH_18(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18);
#define SUBMACRO_DISPATCH_19(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19);
#define SUBMACRO_DISPATCH_20(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20);
#define SUBMACRO_DISPATCH_21(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21);
#define SUBMACRO_DISPATCH_22(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21,CT_##AT22 AN22);
#define SUBMACRO_DISPATCH_23(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22,AN23,AT23) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21,CT_##AT22 AN22,CT_##AT23 AN23);
#define SUBMACRO_DISPATCH_24(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22,AN23,AT23,AN24,AT24) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21,CT_##AT22 AN22,CT_##AT23 AN23,CT_##AT24 AN24);
#define SUBMACRO_DISPATCH_25(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22,AN23,AT23,AN24,AT24,AN25,AT25) \
	[id(DISPID)] CT_##OT FNAME(CT_##AT1 AN1,CT_##AT2 AN2,CT_##AT3 AN3,CT_##AT4 AN4,CT_##AT5 AN5,CT_##AT6 AN6,CT_##AT7 AN7,CT_##AT8 AN8,CT_##AT9 AN9,CT_##AT10 AN10,CT_##AT11 AN11,CT_##AT12 AN12,CT_##AT13 AN13,CT_##AT14 AN14,CT_##AT15 AN15,CT_##AT16 AN16,CT_##AT17 AN17,CT_##AT18 AN18,CT_##AT19 AN19,CT_##AT20 AN20,CT_##AT21 AN21,CT_##AT22 AN22,CT_##AT23 AN23,CT_##AT24 AN24,CT_##AT25 AN25);

// ActiveX interface
#define SUBMACRO_DISPATCHMAP_0(DISPID,OT,FNAME) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_Void)
#define SUBMACRO_DISPATCHMAP_1(DISPID,OT,FNAME,AN1,AT1) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1)
#define SUBMACRO_DISPATCHMAP_2(DISPID,OT,FNAME,AN1,AT1,AN2,AT2) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2)
#define SUBMACRO_DISPATCHMAP_3(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3)
#define SUBMACRO_DISPATCHMAP_4(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4)
#define SUBMACRO_DISPATCHMAP_5(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5)
#define SUBMACRO_DISPATCHMAP_6(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6)
#define SUBMACRO_DISPATCHMAP_7(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7)
#define SUBMACRO_DISPATCHMAP_8(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8)
#define SUBMACRO_DISPATCHMAP_9(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9)
#define SUBMACRO_DISPATCHMAP_10(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10)
#define SUBMACRO_DISPATCHMAP_11(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11)
#define SUBMACRO_DISPATCHMAP_12(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12)
#define SUBMACRO_DISPATCHMAP_13(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13)
#define SUBMACRO_DISPATCHMAP_14(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14)
#define SUBMACRO_DISPATCHMAP_15(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15)
#define SUBMACRO_DISPATCHMAP_16(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16)
#define SUBMACRO_DISPATCHMAP_17(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16 In_##AT17)
#define SUBMACRO_DISPATCHMAP_18(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16 In_##AT17 In_##AT18)
#define SUBMACRO_DISPATCHMAP_19(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16 In_##AT17 In_##AT18 In_##AT19)
#define SUBMACRO_DISPATCHMAP_20(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16 In_##AT17 In_##AT18 In_##AT19 In_##AT20)
#define SUBMACRO_DISPATCHMAP_21(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16 In_##AT17 In_##AT18 In_##AT19 In_##AT20 In_##AT21)
#define SUBMACRO_DISPATCHMAP_22(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16 In_##AT17 In_##AT18 In_##AT19 In_##AT20 In_##AT21 In_##AT22)
#define SUBMACRO_DISPATCHMAP_23(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22,AN23,AT23) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16 In_##AT17 In_##AT18 In_##AT19 In_##AT20 In_##AT21 In_##AT22 In_##AT23)
#define SUBMACRO_DISPATCHMAP_24(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22,AN23,AT23,AN24,AT24) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16 In_##AT17 In_##AT18 In_##AT19 In_##AT20 In_##AT21 In_##AT22 In_##AT23 In_##AT24)
#define SUBMACRO_DISPATCHMAP_25(DISPID,OT,FNAME,AN1,AT1,AN2,AT2,AN3,AT3,AN4,AT4,AN5,AT5,AN6,AT6,AN7,AT7,AN8,AT8,AN9,AT9,AN10,AT10,AN11,AT11,AN12,AT12,AN13,AT13,AN14,AT14,AN15,AT15,AN16,AT16,AN17,AT17,AN18,AT18,AN19,AT19,AN20,AT20,AN21,AT21,AN22,AT22,AN23,AT23,AN24,AT24,AN25,AT25) \
	DISP_FUNCTION_ID(CDFPGECtrl, #FNAME, DISPID, FNAME, Out_##OT, In_##AT1 In_##AT2 In_##AT3 In_##AT4 In_##AT5 In_##AT6 In_##AT7 In_##AT8 In_##AT9 In_##AT10 In_##AT11 In_##AT12 In_##AT13 In_##AT14 In_##AT15 In_##AT16 In_##AT17 In_##AT18 In_##AT19 In_##AT20 In_##AT21 In_##AT22 In_##AT23 In_##AT24 In_##AT25)

#define Offset_Engine 1000
#define Offset_Buffer 2000
#define Offset_Model 3000
#define Offset_Instance 4000
#define Offset_Camera 5000
#define Offset_Shader 6000
#define Offset_DrawSurface 7000
#define Offset_Texture 8000
#define Offset_PostEffect 9000
#define Offset_Debug 10000
#define Offset_Message 11000
#define Offset_Enviroment 12000
#define Offset_LightSource 13000
#define Offset_CPUSurface 14000
#define Offset_Sound 15000
#define Offset_Windows 16000
#define Offset_BoneFrame 17000
#define Offset_Draw 18000
#define Offset_Physics 19000
#define Offset_Physics_Constraint 20000
#define Offset_Physics_RigidBody 21000
#define Offset_Physics_CollisionShape 22000

// High level macro as a reusable table of every function's interface data
#define InterfaceTable(SUBMACRO) \
	SUBMACRO##_0(Offset_Engine + 0,Int32,Engine_Initiate) \
	SUBMACRO##_0(Offset_Engine + 1,Void,Engine_SetCurrentDirectory_InSB) \
	SUBMACRO##_0(Offset_Engine + 2,Void,Engine_RemoveUnusedResources) \
	SUBMACRO##_1(Offset_Engine + 3,Int32,Engine_GetTypeFromID,ID,Int32) \
	SUBMACRO##_1(Offset_Engine + 4,Void,Engine_SetAutomaticSwapChain,Automatic,Boolean) \
	SUBMACRO##_0(Offset_Engine + 5,Int32,Engine_GetAutomaticSwapChain) \
	SUBMACRO##_0(Offset_Engine + 6,Void,Engine_UpdateSwapChain) \
	SUBMACRO##_0(Offset_Engine + 7,Void,Engine_SetCurrentDirectoryRelativeToApplicationPath_InSB) \
	\
	SUBMACRO##_2(Offset_Buffer + 0,Void,WriteToStringBuffer,Index,Int32,NewCharacter,Int16) \
	SUBMACRO##_1(Offset_Buffer + 1,Int16,ReadFromStringBuffer,Index,Int32) \
	SUBMACRO##_0(Offset_Buffer + 2,Int32,GetLengthOfStringBuffer) \
	SUBMACRO##_1(Offset_Buffer + 3,Void,SetLengthOfStringBuffer,NewSize,Int32) \
	SUBMACRO##_1(Offset_Buffer + 4,Void,SetX1,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 5,Void,SetY1,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 6,Void,SetZ1,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 7,Void,SetW1,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 8,Void,SetX2,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 9,Void,SetY2,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 10,Void,SetZ2,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 11,Void,SetW2,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 12,Void,SetX3,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 13,Void,SetY3,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 14,Void,SetZ3,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 15,Void,SetW3,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 16,Void,SetX4,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 17,Void,SetY4,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 18,Void,SetZ4,newValue,Float32) \
	SUBMACRO##_1(Offset_Buffer + 19,Void,SetW4,newValue,Float32) \
	SUBMACRO##_0(Offset_Buffer + 20,Float32,GetX1) \
	SUBMACRO##_0(Offset_Buffer + 21,Float32,GetY1) \
	SUBMACRO##_0(Offset_Buffer + 22,Float32,GetZ1) \
	SUBMACRO##_0(Offset_Buffer + 23,Float32,GetW1) \
	SUBMACRO##_0(Offset_Buffer + 24,Float32,GetX2) \
	SUBMACRO##_0(Offset_Buffer + 25,Float32,GetY2) \
	SUBMACRO##_0(Offset_Buffer + 26,Float32,GetZ2) \
	SUBMACRO##_0(Offset_Buffer + 27,Float32,GetW2) \
	SUBMACRO##_0(Offset_Buffer + 28,Float32,GetX3) \
	SUBMACRO##_0(Offset_Buffer + 29,Float32,GetY3) \
	SUBMACRO##_0(Offset_Buffer + 30,Float32,GetZ3) \
	SUBMACRO##_0(Offset_Buffer + 31,Float32,GetW3) \
	SUBMACRO##_0(Offset_Buffer + 32,Float32,GetX4) \
	SUBMACRO##_0(Offset_Buffer + 33,Float32,GetY4) \
	SUBMACRO##_0(Offset_Buffer + 34,Float32,GetZ4) \
	SUBMACRO##_0(Offset_Buffer + 35,Float32,GetW4) \
	SUBMACRO##_0(Offset_Buffer + 36,Int32,GetLengthOfContactBuffer) \
	SUBMACRO##_1(Offset_Buffer + 37,Int32,ReadFromContactBuffer_BodyA,Index,Int32) \
	SUBMACRO##_1(Offset_Buffer + 38,Int32,ReadFromContactBuffer_BodyB,Index,Int32) \
	SUBMACRO##_1(Offset_Buffer + 39,Void,ReadFromContactBuffer_Position_OutV3,Index,Int32) \
	SUBMACRO##_1(Offset_Buffer + 40,Void,ReadFromContactBuffer_Normal_OutV3,Index,Int32) \
	SUBMACRO##_1(Offset_Buffer + 41,Float32,ReadFromContactBuffer_Impulse,Index,Int32) \
	\
	SUBMACRO##_0(Offset_Model + 0,Int32,Model_CreateEmpty) \
	SUBMACRO##_1(Offset_Model + 1,Void,Model_Delete,Model,Int32) \
	SUBMACRO##_4(Offset_Model + 2,Void,Model_Part_SetTexture,Model,Int32,PartIndex,Int32,TextureChannel,Int32,Texture,Int32) \
	SUBMACRO##_4(Offset_Model + 3,Void,Model_Part_SetShader,Model,Int32,PartIndex,Int32,ShaderChannel,Int32,MaterialShader,Int32) \
	SUBMACRO##_2(Offset_Model + 4,Int32,Model_Part_Create_InSB,Model,Int32,PreallocatedTriangleCount,Int32) \
	SUBMACRO##_2(Offset_Model + 5,Void,Model_Part_Delete,Model,Int32,PartIndex,Int32) \
	SUBMACRO##_1(Offset_Model + 6,Int32,Model_GetNumberOfParts,Model,Int32) \
	SUBMACRO##_2(Offset_Model + 7,Void,Model_Part_GetName_OutSB,Model,Int32,PartIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 8,Void,Model_Part_SetName_InSB,Model,Int32,PartIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 9,Int32,Model_Part_InsertTriangle,Model,Int32,PartIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 10,Int32,Model_Part_GetTriangleCount,Model,Int32,PartIndex,Int32) \
	SUBMACRO##_7(Offset_Model + 11,Void,Model_Part_Vertice_SetPos,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_8(Offset_Model + 12,Void,Model_Part_Vertice_SetTexCoord,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32,U1,Float32,V1,Float32,U2,Float32,V2,Float32) \
	SUBMACRO##_8(Offset_Model + 13,Void,Model_Part_Vertice_SetColor,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32,Red,Float32,Green,Float32,Blue,Float32,Alpha,Float32) \
	SUBMACRO##_7(Offset_Model + 14,Void,Model_Part_Vertice_SetNormal,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_8(Offset_Model + 15,Void,Model_Part_Vertice_SetA,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32,X,Float32,Y,Float32,Z,Float32,W,Float32) \
	SUBMACRO##_8(Offset_Model + 16,Void,Model_Part_Vertice_SetB,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32,X,Float32,Y,Float32,Z,Float32,W,Float32) \
	SUBMACRO##_4(Offset_Model + 17,Void,Model_Part_Vertice_GetPos_OutV3,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32) \
	SUBMACRO##_4(Offset_Model + 18,Void,Model_Part_Vertice_GetTexCoord_OutV4,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32) \
	SUBMACRO##_4(Offset_Model + 19,Void,Model_Part_Vertice_GetColor_OutV4,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32) \
	SUBMACRO##_4(Offset_Model + 20,Void,Model_Part_Vertice_GetNormal_OutV3,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32) \
	SUBMACRO##_4(Offset_Model + 21,Void,Model_Part_Vertice_GetA_OutV4,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32) \
	SUBMACRO##_4(Offset_Model + 22,Void,Model_Part_Vertice_GetB_OutV4,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32) \
	SUBMACRO##_0(Offset_Model + 23,Int32,Model_LoadFromFile_InSB) \
	SUBMACRO##_1(Offset_Model + 24,Int32,Model_SaveToFile_InSB,Model,Int32) \
	SUBMACRO##_3(Offset_Model + 25,Void,Model_Part_SetTexture_ByName_InSB,Model,Int32,PartIndex,Int32,TextureChannel,Int32) \
	SUBMACRO##_3(Offset_Model + 26,Void,Model_Part_SetShader_ByName_InSB,Model,Int32,PartIndex,Int32,ShaderChannel,Int32) \
	SUBMACRO##_3(Offset_Model + 27,Int32,Model_Part_GetTexture,Model,Int32,PartIndex,Int32,TextureChannel,Int32) \
	SUBMACRO##_3(Offset_Model + 28,Int32,Model_Part_GetShader,Model,Int32,PartIndex,Int32,ShaderChannel,Int32) \
	SUBMACRO##_3(Offset_Model + 29,Void,Model_Part_GetTextureName_OutSB,Model,Int32,PartIndex,Int32,TextureChannel,Int32) \
	SUBMACRO##_3(Offset_Model + 30,Void,Model_Part_GetShaderName_OutSB,Model,Int32,PartIndex,Int32,ShaderChannel,Int32) \
	SUBMACRO##_1(Offset_Model + 31,Void,Model_SetFilterUsingName_InSB,Model,Int32) \
	SUBMACRO##_1(Offset_Model + 32,Void,Model_GetFilterName_OutSB,Model,Int32) \
	SUBMACRO##_2(Offset_Model + 33,Void,Model_Part_Delete_PreserveOrder,Model,Int32,PartIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 34,Void,Model_Part_SwapRenderingOrder,Model,Int32,PartIndexA,Int32,PartIndexB,Int32) \
	SUBMACRO##_3(Offset_Model + 35,Void,Model_Part_DeleteTriangle,Model,Int32,PartIndex,Int32,TriangleIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 36,Void,Model_Part_DeleteTriangle_PreserveOrder,Model,Int32,PartIndex,Int32,TriangleIndex,Int32) \
	SUBMACRO##_4(Offset_Model + 37,Void,Model_Part_SwapTriangleRenderingOrder,Model,Int32,PartIndex,Int32,TriangleIndexA,Int32,TriangleIndexB,Int32) \
	SUBMACRO##_5(Offset_Model + 38,Void,Model_Part_Vertice_SetSelected,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32,Selected, Float32) \
	SUBMACRO##_4(Offset_Model + 39,Float32,Model_Part_Vertice_GetSelected,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32) \
	SUBMACRO##_1(Offset_Model + 40,Int32,Model_CreateCopy,Model,Int32) \
	SUBMACRO##_5(Offset_Model + 41,Int32,Model_Part_Triangle_CreateCopy,SourceModel,Int32,SourcePartIndex,Int32,SourceTriangleIndex,Int32,DestModel,Int32,DestPartIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 42,Void,Model_Part_Triangle_Flip,Model,Int32,PartIndex,Int32,TriangleIndex,Int32) \
	SUBMACRO##_4(Offset_Model + 43,Void,Model_Part_SetTextureOverride,Model,Int32,PartIndex,Int32,TextureChannel,Int32,OverrideChannel,Int32) \
	SUBMACRO##_3(Offset_Model + 44,Int32,Model_Part_GetTextureOverride,Model,Int32,PartIndex,Int32,TextureChannel,Int32) \
	SUBMACRO##_1(Offset_Model + 45,Void,Model_SetCullingUsingName_InSB,Model,Int32) \
	SUBMACRO##_1(Offset_Model + 46,Void,Model_GetCullingName_OutSB,Model,Int32) \
	SUBMACRO##_3(Offset_Model + 47,Void,Model_Part_SetMinDetailLevel,Model,Int32,PartIndex,Int32,DetailLevel,Int32) \
	SUBMACRO##_2(Offset_Model + 48,Int32,Model_Part_GetMinDetailLevel,Model,Int32,PartIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 49,Void,Model_Part_SetMaxDetailLevel,Model,Int32,PartIndex,Int32,DetailLevel,Int32) \
	SUBMACRO##_2(Offset_Model + 50,Int32,Model_Part_GetMaxDetailLevel,Model,Int32,PartIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 51,Void,Model_CopyAllParts,SourceModel,Int32,DestModel,Int32) \
	SUBMACRO##_1(Offset_Model + 52,Int32,Model_GetNumberOfBones,Model,Int32) \
	SUBMACRO##_1(Offset_Model + 53,Int32,Model_Bone_Create_InSB,Model,Int32) \
	SUBMACRO##_2(Offset_Model + 54,Void,Model_Bone_GetName_OutSB,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 55,Void,Model_Bone_SetName_InSB,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 56,Void,Model_Bone_SwapHierarchyOrder,Model,Int32,BoneIndexA,Int32,BoneIndexB,Int32) \
	SUBMACRO##_3(Offset_Model + 57,Void,Model_Bone_SetParentIndex,Model,Int32,BoneIndex,Int32,ParentIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 58,Int32,Model_Bone_GetParentIndex,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 59,Void,Model_Bone_SetLength,Model,Int32,BoneIndex,Int32,Length,Float32) \
	SUBMACRO##_2(Offset_Model + 60,Float32,Model_Bone_GetLength,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_5(Offset_Model + 61,Void,Model_Bone_SetObjectSpacePos,Model,Int32,BoneIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_Model + 62,Void,Model_Bone_GetObjectSpacePos_OutV3,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_5(Offset_Model + 63,Void,Model_Bone_SetParentSpacePos,Model,Int32,BoneIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_Model + 64,Void,Model_Bone_GetParentSpacePos_OutV3,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_5(Offset_Model + 65,Void,Model_Bone_SetYAxis,Model,Int32,BoneIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_Model + 66,Void,Model_Bone_GetYAxis_OutV3,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_5(Offset_Model + 67,Void,Model_Bone_SetZAxis,Model,Int32,BoneIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_Model + 68,Void,Model_Bone_GetZAxis_OutV3,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 69,Void,Model_Bone_Delete,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 70,Void,Model_Bone_Delete_PreserveOrder,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_8(Offset_Model + 71,Void,Model_Part_Vertice_SetBoneData,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32,X,Float32,Y,Float32,Z,Float32,W,Float32) \
	SUBMACRO##_4(Offset_Model + 72,Void,Model_Part_Vertice_GetBoneData_OutV4,Model,Int32,PartIndex,Int32,TriangleIndex,Int32,VerticeIndex,Int32) \
	SUBMACRO##_1(Offset_Model + 73,Float32,Model_GetBoundingSphereRadius,Model,Int32) \
	SUBMACRO##_1(Offset_Model + 74,Float32,Model_GetBoundMultiplier,Model,Int32) \
	SUBMACRO##_2(Offset_Model + 75,Void,Model_SetBoundMultiplier,Model,Int32,Multiplier,Float32) \
	SUBMACRO##_1(Offset_Model + 76,Void,Model_GetBoundingBoxMinimum_OutV3,Model,Int32) \
	SUBMACRO##_1(Offset_Model + 77,Void,Model_GetBoundingBoxMaximum_OutV3,Model,Int32) \
	SUBMACRO##_5(Offset_Model + 78,Void,Model_Bone_SetUserData,Model,Int32,BoneIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_Model + 79,Void,Model_Bone_GetUserData_OutV3,Model,Int32,BoneIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 80,Int32,Model_Shape_Create_InSB,Model,Int32,ShapeType,Int32) \
	SUBMACRO##_2(Offset_Model + 81,Void,Model_Shape_GetName_OutSB,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 82,Void,Model_Shape_SetName_InSB,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 83,Void,Model_Shape_Delete,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 84,Void,Model_Shape_Delete_PreserveOrder,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_1(Offset_Model + 85,Int32,Model_GetNumberOfShapes,Model,Int32) \
	SUBMACRO##_5(Offset_Model + 86,Void,Model_Shape_SetPos,Model,Int32,ShapeIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_Model + 87,Void,Model_Shape_GetPos_OutV3,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_5(Offset_Model + 88,Void,Model_Shape_SetXAxis,Model,Int32,ShapeIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_Model + 89,Void,Model_Shape_GetXAxis_OutV3,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_5(Offset_Model + 90,Void,Model_Shape_SetYAxis,Model,Int32,ShapeIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_Model + 91,Void,Model_Shape_GetYAxis_OutV3,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_5(Offset_Model + 92,Void,Model_Shape_SetZAxis,Model,Int32,ShapeIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_Model + 93,Void,Model_Shape_GetZAxis_OutV3,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 94,Void,Model_Shape_SetShapeType,Model,Int32,ShapeIndex,Int32,ShapeType,Int32) \
	SUBMACRO##_2(Offset_Model + 95,Int32,Model_Shape_GetShapeType,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 96,Void,Model_Shape_SetCollisionType,Model,Int32,ShapeIndex,Int32,CollisionType,Int32) \
	SUBMACRO##_2(Offset_Model + 97,Int32,Model_Shape_GetCollisionType,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 98,Void,Model_Shape_SetRadius,Model,Int32,ShapeIndex,Int32,Radius,Float32) \
	SUBMACRO##_2(Offset_Model + 99,Float32,Model_Shape_GetRadius,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 100,Void,Model_Shape_SetHalfWidth,Model,Int32,ShapeIndex,Int32,HalfWidth,Float32) \
	SUBMACRO##_2(Offset_Model + 101,Float32,Model_Shape_GetHalfWidth,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 102,Void,Model_Shape_SetHalfHeight,Model,Int32,ShapeIndex,Int32,HalfHeight,Float32) \
	SUBMACRO##_2(Offset_Model + 103,Float32,Model_Shape_GetHalfHeight,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 104,Void,Model_Shape_SetHalfDepth,Model,Int32,ShapeIndex,Int32,HalfDepth,Float32) \
	SUBMACRO##_2(Offset_Model + 105,Float32,Model_Shape_GetHalfDepth,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_2(Offset_Model + 106,Int32,Model_Shape_GetNumberOfPoints,Model,Int32,ShapeIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 107,Void,Model_Shape_GetPoint_OutV3,Model,Int32,ShapeIndex,Int32,PointIndex,Int32) \
	SUBMACRO##_6(Offset_Model + 108,Void,Model_Shape_SetPoint,Model,Int32,ShapeIndex,Int32,PointIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_5(Offset_Model + 109,Int32,Model_Shape_InsertPoint,Model,Int32,ShapeIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_3(Offset_Model + 110,Void,Model_Shape_DeletePoint,Model,Int32,ShapeIndex,Int32,PointIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 111,Void,Model_Shape_DeletePoint_PreserveOrder,Model,Int32,ShapeIndex,Int32,PointIndex,Int32) \
	SUBMACRO##_3(Offset_Model + 112,Void,Model_Shape_SwapOrder,Model,Int32,ShapeIndexA,Int32,ShapeIndexB,Int32) \
	SUBMACRO##_4(Offset_Model + 113,Void,Model_Shape_SwapPointOrder,Model,Int32,ShapeIndex,Int32,PointIndexA,Int32,PointIndexB,Int32) \
	SUBMACRO##_3(Offset_Model + 114,Void,Model_Shape_GetPointDir_OutV3,Model,Int32,ShapeIndex,Int32,PointIndex,Int32) \
	SUBMACRO##_6(Offset_Model + 115,Void,Model_Shape_SetPointDir,Model,Int32,ShapeIndex,Int32,PointIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	\
	SUBMACRO##_6(Offset_Instance + 0,Void,Instance_SetUserDefinedData,Instance,Int32,Index,Int32,X,Float32,Y,Float32,Z,Float32,W,Float32) \
	SUBMACRO##_2(Offset_Instance + 1,Void,Instance_GetUserDefinedData_OutV4,Instance,Int32,Index,Int32) \
	SUBMACRO##_1(Offset_Instance + 2,Int32,Instance_Create,Model,Int32) \
	SUBMACRO##_2(Offset_Instance + 3,Void,Instance_ReplaceModel,Instance,Int32,Model,Int32) \
	SUBMACRO##_4(Offset_Instance + 4,Void,Instance_SetPosition,Instance,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_4(Offset_Instance + 5,Void,Instance_SetXAxis,Instance,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_4(Offset_Instance + 6,Void,Instance_SetYAxis,Instance,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_4(Offset_Instance + 7,Void,Instance_SetZAxis,Instance,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_1(Offset_Instance + 8,Void,Instance_GetPosition_OutV3,Instance,Int32) \
	SUBMACRO##_1(Offset_Instance + 9,Void,Instance_GetXAxis_OutV3,Instance,Int32) \
	SUBMACRO##_1(Offset_Instance + 10,Void,Instance_GetYAxis_OutV3,Instance,Int32) \
	SUBMACRO##_1(Offset_Instance + 11,Void,Instance_GetZAxis_OutV3,Instance,Int32) \
	SUBMACRO##_3(Offset_Instance + 12,Void,Instance_SetVisibility,Instance,Int32,ShaderChannel,Int32,Visible,Boolean) \
	SUBMACRO##_2(Offset_Instance + 13,Int32,Instance_GetVisibility,Instance,Int32,ShaderChannel,Int32) \
	SUBMACRO##_2(Offset_Instance + 14,Void,Instance_SetMirrored,Instance,Int32,Mirrored,Boolean) \
	SUBMACRO##_1(Offset_Instance + 15,Int32,Instance_GetMirrored,Instance,Int32) \
	SUBMACRO##_1(Offset_Instance + 16,Void,Instance_Delete,Instance,Int32) \
	SUBMACRO##_5(Offset_Instance + 17,Void,Instance_SetColor,Instance,Int32,Red,Float32,Green,Float32,Blue,Float32,Alpha,Float32) \
	SUBMACRO##_1(Offset_Instance + 18,Void,Instance_GetColor_OutV4,Instance,Int32) \
	SUBMACRO##_1(Offset_Instance + 19,Void,Instance_Get4x4System_OutM4,Instance,Int32) \
	SUBMACRO##_3(Offset_Instance + 20,Void,Instance_SetTextureOverride,Instance,Int32,OverrideChannel,Int32,DrawSurfaceOrTexture,Int32) \
	SUBMACRO##_2(Offset_Instance + 21,Int32,Instance_GetTextureOverride,Instance,Int32,OverrideChannel,Int32) \
	SUBMACRO##_2(Offset_Instance + 22,Void,Instance_SetDetailLevel,Instance,Int32,DetailLevel,Int32) \
	SUBMACRO##_1(Offset_Instance + 23,Int32,Instance_GetDetailLevel,Instance,Int32) \
	SUBMACRO##_2(Offset_Instance + 24,Void,Instance_SetAutoDetailLevel,Instance,Int32,AutoDetailLevel,Boolean) \
	SUBMACRO##_1(Offset_Instance + 25,Int32,Instance_GetAutoDetailLevel,Instance,Int32) \
	SUBMACRO##_2(Offset_Instance + 26,Void,Instance_AssignBoneFrame,Instance,Int32,BoneFrame,Int32) \
	SUBMACRO##_3(Offset_Instance + 27,Void,Instance_PlaceAtRigidBody,Instance,Int32,RigidBody,Int32,UseLocalScaling,Boolean) \
	SUBMACRO##_4(Offset_Instance + 28,Void,Instance_PlaceAtRigidBody_Interpolated,Instance,Int32,RigidBody,Int32,TimeOffset,Float32,UseLocalScaling,Boolean) \
	SUBMACRO##_3(Offset_Instance + 29,Void,Instance_FollowRigidBody,Instance,Int32,RigidBody,Int32,UseLocalScaling,Boolean) \
	SUBMACRO##_1(Offset_Instance + 30,Int32,Instance_GetFollowedRigidBody,Instance,Int32) \
	SUBMACRO##_2(Offset_Instance + 31,Void,Instance_SetDetailLevel_Float,Instance,Int32,DetailLevel,Float32) \
	SUBMACRO##_1(Offset_Instance + 32,Float32,Instance_GetDetailLevel_Float,Instance,Int32) \
	\
	SUBMACRO##_3(Offset_Camera + 0,Void,Camera_RenderScene,InputCamera,Int32,OutputSurface,Int32,ShaderChannel,Int32) \
	SUBMACRO##_0(Offset_Camera + 1,Int32,Camera_Create) \
	SUBMACRO##_2(Offset_Camera + 2,Void,Camera_SetHorizontalFOV_InRadians,Camera,Int32,FOV,Float32) \
	SUBMACRO##_2(Offset_Camera + 3,Void,Camera_SetVerticalFOV_InRadians,Camera,Int32,FOV,Float32) \
	SUBMACRO##_2(Offset_Camera + 4,Void,Camera_SetHorizontalFOV_InDegrees,Camera,Int32,FOV,Float32) \
	SUBMACRO##_2(Offset_Camera + 5,Void,Camera_SetVerticalFOV_InDegrees,Camera,Int32,FOV,Float32) \
	SUBMACRO##_10(Offset_Camera + 6,Void,Camera_Place,Camera,Int32,Position_X,Float32,Position_Y,Float32,Position_Z,Float32,Target_X,Float32,Target_Y,Float32,Target_Z,Float32,Up_X,Float32,Up_Y,Float32,Up_Z,Float32) \
	SUBMACRO##_1(Offset_Camera + 7,Void,Camera_GetPosition_OutV3,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 8,Void,Camera_GetTarget_OutV3,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 9,Void,Camera_GetUp_OutV3,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 10,Void,Camera_Delete,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 11,Float32,Camera_GetFieldOfViewInRadians,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 12,Float32,Camera_GetFieldOfViewInDegrees,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 13,Int32,Camera_IsFieldOfViewVertical,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 14,Void,Camera_Get4x4System_OutM4,Camera,Int32) \
	SUBMACRO##_6(Offset_Camera + 15,Void,Camera_GiveCuttingPlane,Camera,Int32,NX,Float32,NY,Float32,NZ,Float32,D,Float32,RefractiveMultiplier,Float32) \
	SUBMACRO##_1(Offset_Camera + 16,Void,Camera_RemoveCuttingPlane,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 17,Int32,Camera_HasCuttingPlane,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 18,Void,Camera_GetCuttingPlane_OutV4,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 19,Float32,Camera_GetRefractiveMultiplier,Camera,Int32) \
	SUBMACRO##_1(Offset_Camera + 20,Int32,Camera_IsOrthogonal,Camera,Int32) \
	SUBMACRO##_2(Offset_Camera + 21,Void,Camera_SetOrthogonal,Camera,Int32,Orthogonal,Boolean) \
	SUBMACRO##_1(Offset_Camera + 22,Float32,Camera_GetHalfWidth,Camera,Int32) \
	SUBMACRO##_2(Offset_Camera + 23,Void,Camera_SetHalfWidth,Camera,Int32,HalfWidth,Float32) \
	SUBMACRO##_1(Offset_Camera + 24,Float32,Camera_GetHalfHeight,Camera,Int32) \
	SUBMACRO##_2(Offset_Camera + 25,Void,Camera_SetHalfHeight,Camera,Int32,HalfHeight,Float32) \
	SUBMACRO##_1(Offset_Camera + 26,Void,Camera_GetDirection_OutV3,Camera,Int32) \
	SUBMACRO##_2(Offset_Camera + 27,Int32,Camera_GetDebugViewVisibility,Camera,Int32,DebugViewIndex,Int32) \
	SUBMACRO##_3(Offset_Camera + 28,Void,Camera_SetDebugViewVisibility,Camera,Int32,DebugViewIndex,Int32,Visible,Boolean) \
	SUBMACRO##_12(Offset_Camera + 29,Void,Camera_RenderInstance,InputCamera,Int32,OutputSurface,Int32,Instance,Int32,MaterialShaderOverride,Int32,FilterIndex,Int32,RenderingMethod,Int32,UseDepthBuffer,Boolean,InstanceColor_Red,Float32,InstanceColor_Green,Float32,InstanceColor_Blue,Float32,InstanceColor_Alpha,Float32,Part,Int32) \
	\
	SUBMACRO##_0(Offset_Shader + 0,Int32,Shader_LoadAsMaterial_InSB) \
	SUBMACRO##_0(Offset_Shader + 1,Int32,Shader_LoadAsPostEffect_InSB) \
	SUBMACRO##_1(Offset_Shader + 2,Void,Shader_GetFilename_OutSB,Shader,Int32) \
	SUBMACRO##_1(Offset_Shader + 3,Void,Shader_Unlock,Shader,Int32) \
	SUBMACRO##_1(Offset_Shader + 4,Void,Shader_UseAsDefaultMaterialShader,MaterialShader,Int32) \
	SUBMACRO##_1(Offset_Shader + 5,Void,Shader_SetGlobalTime,NewValue,Float32) \
	SUBMACRO##_0(Offset_Shader + 6,Float32,Shader_GetGlobalTime) \
	SUBMACRO##_0(Offset_Shader + 7,Int32,Shader_LoadAsDrawShader_InSB) \
	\
	SUBMACRO##_0(Offset_DrawSurface + 0,Int32,DrawSurface_GetFinalOutput) \
	SUBMACRO##_4(Offset_DrawSurface + 1,Int32,DrawSurface_CreateFixed,newWidth,Int32,newHeight,Int32,numberOfDepthBuffers,Int32,useExtraColorBuffer,Boolean) \
	SUBMACRO##_6(Offset_DrawSurface + 2,Int32,DrawSurface_CreateAutoSized,widthMultiplier,Float32,heightMultiplier,Float32,widthAdder,Int32,heightAdder,Int32,numberOfDepthBuffers,Int32,useExtraColorBuffer,Boolean) \
	SUBMACRO##_1(Offset_DrawSurface + 3,Void,DrawSurface_Delete,DrawSurface,Int32) \
	SUBMACRO##_1(Offset_DrawSurface + 4,Int32,DrawSurface_GetWidth,DrawSurface,Int32) \
	SUBMACRO##_1(Offset_DrawSurface + 5,Int32,DrawSurface_GetHeight,DrawSurface,Int32) \
	SUBMACRO##_1(Offset_DrawSurface + 6,Int32,DrawSurface_IsAutoSized,DrawSurface,Int32) \
	SUBMACRO##_1(Offset_DrawSurface + 7,Int32,DrawSurface_GetNumberOfDepthBuffers,DrawSurface,Int32) \
	SUBMACRO##_1(Offset_DrawSurface + 8,Int32,DrawSurface_HasExtraColorBuffer,DrawSurface,Int32) \
	SUBMACRO##_3(Offset_DrawSurface + 9,Void,DrawSurface_GetPixelColor_OutV4,DrawSurface,Int32,X,Int32,Y,Int32) \
	SUBMACRO##_1(Offset_DrawSurface + 10,Int32,DrawSurface_SaveToFile_InSB,DrawSurface,Int32) \
	SUBMACRO##_5(Offset_DrawSurface + 11,Void,DrawSurface_FillWithColor,DrawSurface,Int32,Red,Float32,Green,Float32,Blue,Float32,Alpha,Float32) \
	SUBMACRO##_7(Offset_DrawSurface + 12,Void,DrawSurface_SetPixelColor,DrawSurface,Int32,X,Int32,Y,Int32,Red,Float32,Green,Float32,Blue,Float32,Alpha,Float32) \
	SUBMACRO##_1(Offset_DrawSurface + 13,Void,DrawSurface_ClearDepthBuffer,DrawSurface,Int32) \
	\
	SUBMACRO##_0(Offset_Texture + 0,Int32,Texture_Load_InSB) \
	SUBMACRO##_1(Offset_Texture + 1,Int32,Texture_GetWidth,Texture,Int32) \
	SUBMACRO##_1(Offset_Texture + 2,Int32,Texture_GetHeight,Texture,Int32) \
	SUBMACRO##_1(Offset_Texture + 3,Void,Texture_GetFilename_OutSB,Texture,Int32) \
	SUBMACRO##_1(Offset_Texture + 4,Void,Texture_Unlock,Texture,Int32) \
	SUBMACRO##_1(Offset_Texture + 5,Void,Texture_UseAsDefaultTexture,Texture,Int32) \
	SUBMACRO##_1(Offset_Texture + 6,Void,Texture_UseAsLightProjectionAtlas,Texture,Int32) \
	\
	SUBMACRO##_2(Offset_PostEffect + 0,Void,PostEffect_RenderShader,OutputSurface,Int32,PostEffect,Int32) \
	SUBMACRO##_3(Offset_PostEffect + 1,Void,PostEffect_GiveInputSurface,Index,Int32,DrawSurfaceOrTexture,Int32, SubresourceType,Int32) \
	SUBMACRO##_5(Offset_PostEffect + 2,Void,PostEffect_GiveInputVector,Index,Int32,X,Float32,Y,Float32,Z,Float32,W,Float32) \
	\
	SUBMACRO##_1(Offset_Debug + 0,Void,Debug_PrintGeneralData_OutSB,MaxCountPerType,Int32) \
	SUBMACRO##_0(Offset_Debug + 1,Int32,Debug_GetLastNumberOfVisibleLightSources) \
	SUBMACRO##_0(Offset_Debug + 2,Int32,Debug_GetLastNumberOfCulledLightSources) \
	SUBMACRO##_0(Offset_Debug + 3,Int32,Debug_GetLastNumberOfVisibleInstances) \
	SUBMACRO##_0(Offset_Debug + 4,Int32,Debug_GetLastNumberOfCulledInstances) \
	SUBMACRO##_0(Offset_Debug + 5,Float32,Debug_GetPartAllocatedOfDepthAtlas) \
	SUBMACRO##_0(Offset_Debug + 6,Int32,Debug_WasDepthAtlasAllocationDenied) \
	\
	SUBMACRO##_0(Offset_Message + 0,Int32,Message_GetCount) \
	SUBMACRO##_0(Offset_Message + 1,Void,Message_GetContent_OutSB) \
	\
	SUBMACRO##_0(Offset_Enviroment + 0,Void,Enviroment_GetBackgroundColor_OutV4) \
	SUBMACRO##_4(Offset_Enviroment + 1,Void,Enviroment_SetBackgroundColor,Red,Float32,Green,Float32,Blue,Float32,Alpha,Float32) \
	SUBMACRO##_0(Offset_Enviroment + 2,Float32,Enviroment_GetFarClipPlane) \
	SUBMACRO##_1(Offset_Enviroment + 3,Void,Enviroment_SetFarClipPlane,NewValue,Float32) \
	SUBMACRO##_0(Offset_Enviroment + 4,Float32,Enviroment_GetNearClipPlane) \
	SUBMACRO##_1(Offset_Enviroment + 5,Void,Enviroment_SetNearClipPlane,NewValue,Float32) \
	SUBMACRO##_0(Offset_Enviroment + 6,Float32,Enviroment_GetMaxFogIntensity) \
	SUBMACRO##_1(Offset_Enviroment + 7,Void,Enviroment_SetMaxFogIntensity,NewValue,Float32) \
	SUBMACRO##_0(Offset_Enviroment + 8,Float32,Enviroment_GetMediumHighDetailLimit) \
	SUBMACRO##_1(Offset_Enviroment + 9,Void,Enviroment_SetMediumHighDetailLimit,NewValue,Float32) \
	SUBMACRO##_0(Offset_Enviroment + 10,Float32,Enviroment_GetLowMediumDetailLimit) \
	SUBMACRO##_1(Offset_Enviroment + 11,Void,Enviroment_SetLowMediumDetailLimit,NewValue,Float32) \
	SUBMACRO##_3(Offset_Enviroment + 12,Void,Enviroment_UpdateAutomaticDetailLevels,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_1(Offset_Enviroment + 13,Void,Enviroment_UseAsSkyInstance,Instance,Int32) \
	\
	SUBMACRO##_0(Offset_LightSource + 0,Void,LightSource_GetAmbientLight_OutV3) \
	SUBMACRO##_3(Offset_LightSource + 1,Void,LightSource_SetAmbientLight,R,Float32,G,Float32,B,Float32) \
	SUBMACRO##_7(Offset_LightSource + 2,Int32,LightSource_Create_Point_Shadowless,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,Radius,Float32,R,Float32,G,Float32,B,Float32) \
	SUBMACRO##_6(Offset_LightSource + 3,Int32,LightSource_Create_Sun_Shadowless,Dir_X,Float32,Dir_Y,Float32,Dir_Z,Float32,R,Float32,G,Float32,B,Float32) \
	SUBMACRO##_15(Offset_LightSource + 4,Int32,LightSource_Create_Spotlight_RoundAndSoft_Shadowless,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,Dir_X,Float32,Dir_Y,Float32,Dir_Z,Float32,Up_X,Float32,Up_Y,Float32,Up_Z,Float32,Radius,Float32,R,Float32,G,Float32,B,Float32,WidthSlope,Float32,HeightSlope,Float32) \
	SUBMACRO##_1(Offset_LightSource + 5,Void,LightSource_Delete,LightSource,Int32) \
	SUBMACRO##_2(Offset_LightSource + 6,Void,LightSource_SetRadius,LightSource,Int32,NewValue,Float32) \
	SUBMACRO##_1(Offset_LightSource + 7,Float32,LightSource_GetRadius,LightSource,Int32) \
	SUBMACRO##_2(Offset_LightSource + 8,Void,LightSource_SetNearClip,LightSource,Int32,NewValue,Float32) \
	SUBMACRO##_1(Offset_LightSource + 9,Float32,LightSource_GetNearClip,LightSource,Int32) \
	SUBMACRO##_2(Offset_LightSource + 10,Void,LightSource_SetWidthSlope,LightSource,Int32,NewValue,Float32) \
	SUBMACRO##_1(Offset_LightSource + 11,Float32,LightSource_GetWidthSlope,LightSource,Int32) \
	SUBMACRO##_2(Offset_LightSource + 12,Void,LightSource_SetHeightSlope,LightSource,Int32,NewValue,Float32) \
	SUBMACRO##_1(Offset_LightSource + 13,Float32,LightSource_GetHeightSlope,LightSource,Int32) \
	SUBMACRO##_4(Offset_LightSource + 14,Void,LightSource_SetColor,LightSource,Int32,R,Float32,G,Float32,B,Float32) \
	SUBMACRO##_1(Offset_LightSource + 15,Void,LightSource_GetColor_OutV3,LightSource,Int32) \
	SUBMACRO##_4(Offset_LightSource + 16,Void,LightSource_SetPos,LightSource,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_1(Offset_LightSource + 17,Void,LightSource_GetPos_OutV3,LightSource,Int32) \
	SUBMACRO##_7(Offset_LightSource + 18,Void,LightSource_SetDirection,LightSource,Int32, Dir_X,Float32, Dir_Y,Float32, Dir_Z,Float32, Up_X,Float32, Up_Y,Float32, Up_Z,Float32) \
	SUBMACRO##_1(Offset_LightSource + 19,Void,LightSource_GetAxisSystem_OutM3,LightSource,Int32) \
	SUBMACRO##_5(Offset_LightSource + 20,Void,LightSource_SetTextureAtlasRect,LightSource,Int32,MinU,Float32,MaxU,Float32,MinV,Float32,MaxV,Float32) \
	SUBMACRO##_1(Offset_LightSource + 21,Void,LightSource_GetTextureAtlasRect_OutV4,LightSource,Int32) \
	SUBMACRO##_19(Offset_LightSource + 22,Int32,LightSource_Create_Spotlight_Atlas_Shadowless,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,Dir_X,Float32,Dir_Y,Float32,Dir_Z,Float32,Up_X,Float32,Up_Y,Float32,Up_Z,Float32,Radius,Float32,R,Float32,G,Float32,B,Float32,WidthSlope,Float32,HeightSlope,Float32,MinU,Float32,MaxU,Float32,MinV,Float32,MaxV,Float32) \
	SUBMACRO##_0(Offset_LightSource + 23,Void,LightSource_ClearShadows) \
	SUBMACRO##_18(Offset_LightSource + 24,Int32,LightSource_Create_Spotlight_RoundAndSoft_Shadowcasting,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,Dir_X,Float32,Dir_Y,Float32,Dir_Z,Float32,Up_X,Float32,Up_Y,Float32,Up_Z,Float32,Radius,Float32,R,Float32,G,Float32,B,Float32,WidthSlope,Float32,HeightSlope,Float32,NearClip,Float32,ShadowTransparency,Float32,ResolutionGroup,Int32) \
	SUBMACRO##_22(Offset_LightSource + 25,Int32,LightSource_Create_Spotlight_Atlas_Shadowcasting,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,Dir_X,Float32,Dir_Y,Float32,Dir_Z,Float32,Up_X,Float32,Up_Y,Float32,Up_Z,Float32,Radius,Float32,R,Float32,G,Float32,B,Float32,WidthSlope,Float32,HeightSlope,Float32,MinU,Float32,MaxU,Float32,MinV,Float32,MaxV,Float32,NearClip,Float32,ShadowTransparency,Float32,ResolutionGroup,Int32) \
	SUBMACRO##_2(Offset_LightSource + 26,Void,LightSource_SetShadowTransparency,LightSource,Int32,NewValue,Float32) \
	SUBMACRO##_1(Offset_LightSource + 27,Float32,LightSource_GetShadowTransparency,LightSource,Int32) \
	SUBMACRO##_2(Offset_LightSource + 28,Void,LightSource_SetResolutionGroup,LightSource,Int32,NewValue,Int32) \
	SUBMACRO##_1(Offset_LightSource + 29,Int32,LightSource_GetResolutionGroup,LightSource,Int32) \
	SUBMACRO##_1(Offset_LightSource + 30,Void,LightSource_SetDepthAtlasResolution,NewValue,Int32) \
	SUBMACRO##_0(Offset_LightSource + 31,Int32,LightSource_GetDepthAtlasResolution) \
	SUBMACRO##_20(Offset_LightSource + 32,Int32,LightSource_Create_Sun_Shadowcasting_SingleLayer,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,Dir_X,Float32,Dir_Y,Float32,Dir_Z,Float32,Up_X,Float32,Up_Y,Float32,Up_Z,Float32,NearClip,Float32,FarClip,Float32,Red,Float32,Green,Float32,Blue,Float32,HalfWidth,Float32,HalfHeight,Float32,ShadowTransparency,Float32,ResolutionGroup,Int32,OutsideIntensity,Float32,FadeSize,Float32) \
	SUBMACRO##_2(Offset_LightSource + 33,Void,LightSource_SetOutsideIntensity,LightSource,Int32,NewValue,Float32) \
	SUBMACRO##_1(Offset_LightSource + 34,Float32,LightSource_GetOutsideIntensity,LightSource,Int32) \
	SUBMACRO##_2(Offset_LightSource + 35,Void,LightSource_SetFadeSize,LightSource,Int32,NewValue,Float32) \
	SUBMACRO##_1(Offset_LightSource + 36,Float32,LightSource_GetFadeSize,LightSource,Int32) \
	SUBMACRO##_2(Offset_LightSource + 37,Void,LightSource_SetEnabled,LightSource,Int32,Enabled,Boolean) \
	SUBMACRO##_1(Offset_LightSource + 38,Int32,LightSource_GetEnabled,LightSource,Int32) \
	\
	SUBMACRO##_6(Offset_CPUSurface + 0,Int32,CPUSurface_CreateFixed,newWidth,Int32,newHeight,Int32,Red,Float32,Green,Float32,Blue,Float32,Alpha,Float32) \
	SUBMACRO##_1(Offset_CPUSurface + 1,Void,CPUSurface_Delete,CPUSurface,Int32) \
	SUBMACRO##_1(Offset_CPUSurface + 2,Int32,CPUSurface_GetWidth,CPUSurface,Int32) \
	SUBMACRO##_1(Offset_CPUSurface + 3,Int32,CPUSurface_GetHeight,CPUSurface,Int32) \
	SUBMACRO##_3(Offset_CPUSurface + 4,Void,CPUSurface_GetPixelColor_Clamped_OutV4,CPUSurface,Int32,X,Int32,Y,Int32) \
	SUBMACRO##_7(Offset_CPUSurface + 5,Void,CPUSurface_GetPixelColor_Border_OutV4,CPUSurface,Int32,X,Int32,Y,Int32,DefaultRed,Float32,DefaultGreen,Float32,DefaultBlue,Float32,DefaultAlpha,Float32) \
	SUBMACRO##_7(Offset_CPUSurface + 6,Void,CPUSurface_SetPixelColor_Ignore,CPUSurface,Int32,X,Int32,Y,Int32,Red,Float32,Green,Float32,Blue,Float32,Alpha,Float32) \
	SUBMACRO##_5(Offset_CPUSurface + 7,Void,CPUSurface_FillWithColor,CPUSurface,Int32,Red,Float32,Green,Float32,Blue,Float32,Alpha,Float32) \
	SUBMACRO##_8(Offset_CPUSurface + 8,Void,CPUSurface_CopyRectFromDrawSurface,Input_DrawSurface,Int32,Output_CPUSurface,Int32,SourceLeft,Int32,SourceTop,Int32,DestLeft,Int32,DestTop,Int32,Width,Int32,Height,Int32) \
	SUBMACRO##_7(Offset_CPUSurface + 9,Void,CPUSurface_SetPixelColor_Warning,CPUSurface,Int32,X,Int32,Y,Int32,Red,Float32,Green,Float32,Blue,Float32,Alpha,Float32)\
	\
	SUBMACRO##_3(Offset_Sound + 0,Int32,Sound_Buffer_LoadFromFile_InSB,NumberOfCopies,Int32,LoadAs3DSound,Boolean,LoadAsEditable,Boolean) \
	SUBMACRO##_1(Offset_Sound + 1,Void,Sound_Buffer_Editable_SaveToFile_InSB,SoundBuffer,Int32) \
	SUBMACRO##_1(Offset_Sound + 2,Void,Sound_Buffer_Delete,SoundBuffer,Int32) \
	SUBMACRO##_4(Offset_Sound + 3,Void,Sound_Buffer_Play,SoundBuffer,Int32,Index,Int32,FromBeginning,Boolean,Looping,Boolean) \
	SUBMACRO##_2(Offset_Sound + 4,Void,Sound_Buffer_Stop,SoundBuffer,Int32,Index,Int32) \
	SUBMACRO##_3(Offset_Sound + 5,Void,Sound_Buffer_SetSpeed,SoundBuffer,Int32,Index,Int32,Speed,Float32) \
	SUBMACRO##_3(Offset_Sound + 6,Void,Sound_Buffer_SetVolume,SoundBuffer,Int32,Index,Int32,Volume,Float32) \
	SUBMACRO##_5(Offset_Sound + 7,Void,Sound_Buffer_3D_SetPosition,SoundBuffer,Int32,Index,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_1(Offset_Sound + 8,Int32,Sound_Buffer_GetNumberOfCopies,SoundBuffer,Int32) \
	SUBMACRO##_1(Offset_Sound + 9,Int32,Sound_Buffer_Is3DSound,SoundBuffer,Int32) \
	SUBMACRO##_1(Offset_Sound + 10,Int32,Sound_Buffer_IsEditable,SoundBuffer,Int32) \
	SUBMACRO##_1(Offset_Sound + 11,Int32,Sound_Buffer_GetLastPlayedIndex,SoundBuffer,Int32) \
	SUBMACRO##_9(Offset_Sound + 12,Void,Sound_PlaceGlobalListener,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,Front_X,Float32,Front_Y,Float32,Front_Z,Float32,Up_X,Float32,Up_Y,Float32,Up_Z,Float32) \
	SUBMACRO##_2(Offset_Sound + 13,Int32,Sound_Buffer_IsPlaying,SoundBuffer,Int32,Index,Int32) \
	SUBMACRO##_2(Offset_Sound + 14,Float32,Sound_Buffer_GetSpeed,SoundBuffer,Int32,Index,Int32) \
	SUBMACRO##_2(Offset_Sound + 15,Float32,Sound_Buffer_GetVolume,SoundBuffer,Int32,Index,Int32) \
	SUBMACRO##_2(Offset_Sound + 16,Void,Sound_Buffer_3D_GetPosition_OutV3,SoundBuffer,Int32,Index,Int32) \
	SUBMACRO##_1(Offset_Sound + 17,Void,Sound_SetMetersPerDistanceUnit,Meters,Float32) \
	SUBMACRO##_0(Offset_Sound + 18,Float32,Sound_GetMetersPerDistanceUnit) \
	SUBMACRO##_1(Offset_Sound + 19,Int32,Sound_Buffer_GetNumberOfChannels,SoundBuffer,Int32) \
	SUBMACRO##_1(Offset_Sound + 20,Int32,Sound_Buffer_GetNumberOfSamplesPerChannel,SoundBuffer,Int32) \
	SUBMACRO##_1(Offset_Sound + 21,Int32,Sound_Buffer_GetSamplesPerSecond,SoundBuffer,Int32) \
	SUBMACRO##_5(Offset_Sound + 22,Int32,Sound_Buffer_CreateEmpty,NumberOfCopies,Int32,CreateAs3DSound,Boolean,SamplesPerSecond,Int32,NumberOfChannels,Int32,NumberOfSamplesPerChannel,Int32) \
	SUBMACRO##_1(Offset_Sound + 23,Int32,Sound_Buffer_Editable_Update,SoundBuffer,Int32) \
	SUBMACRO##_4(Offset_Sound + 24,Void,Sound_Buffer_Editable_SetSample,SoundBuffer,Int32,Time,Int32,Channel,Int32,NewValue,Float32) \
	SUBMACRO##_3(Offset_Sound + 25,Float32,Sound_Buffer_Editable_GetSample,SoundBuffer,Int32,Time,Int32,Channel,Int32) \
	\
	SUBMACRO##_0(Offset_Windows + 0,Int32,Windows_GetCursorPos_X) \
	SUBMACRO##_0(Offset_Windows + 1,Int32,Windows_GetCursorPos_Y) \
	SUBMACRO##_2(Offset_Windows + 2,Void,Windows_SetCursorPos,X,Int32,Y,Int32) \
	\
	SUBMACRO##_0(Offset_BoneFrame + 0,Int32,BoneFrame_CreateEmpty) \
	SUBMACRO##_1(Offset_BoneFrame + 1,Int32,BoneFrame_CreateFromDefaultPose,Model,Int32) \
	SUBMACRO##_1(Offset_BoneFrame + 2,Void,BoneFrame_Delete,BoneFrame,Int32) \
	SUBMACRO##_2(Offset_BoneFrame + 3,Void,BoneFrame_GetPosition_OutV3,BoneFrame,Int32,BoneIndex,Int32) \
	SUBMACRO##_5(Offset_BoneFrame + 4,Void,BoneFrame_SetPosition,BoneFrame,Int32,BoneIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_BoneFrame + 5,Void,BoneFrame_GetYAxis_OutV3,BoneFrame,Int32,BoneIndex,Int32) \
	SUBMACRO##_5(Offset_BoneFrame + 6,Void,BoneFrame_SetYAxis,BoneFrame,Int32,BoneIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_BoneFrame + 7,Void,BoneFrame_GetZAxis_OutV3,BoneFrame,Int32,BoneIndex,Int32) \
	SUBMACRO##_5(Offset_BoneFrame + 8,Void,BoneFrame_SetZAxis,BoneFrame,Int32,BoneIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_2(Offset_BoneFrame + 9,Void,BoneFrame_GetUserData_OutV3,BoneFrame,Int32,BoneIndex,Int32) \
	SUBMACRO##_5(Offset_BoneFrame + 10,Void,BoneFrame_SetUserData,BoneFrame,Int32,BoneIndex,Int32,X,Float32,Y,Float32,Z,Float32) \
	\
	SUBMACRO##_9(Offset_Draw + 0,Void,Draw_RenderQuad,OutputSurface,Int32,DrawShader,Int32,Center_X,Float32,Center_Y,Float32,XAxis_X,Float32,XAxis_Y,Float32,YAxis_X,Float32,YAxis_Y,Float32,FilterType,Int32) \
	SUBMACRO##_2(Offset_Draw + 1,Void,Draw_GiveInputSurface,Index,Int32,DrawSurfaceOrTexture,Int32) \
	SUBMACRO##_5(Offset_Draw + 2,Void,Draw_GiveInputVector,Index,Int32,X,Float32,Y,Float32,Z,Float32,W,Float32) \
	SUBMACRO##_4(Offset_Draw + 3,Void,Draw_GiveInputColor,R,Float32,G,Float32,B,Float32,A,Float32) \
	SUBMACRO##_4(Offset_Draw + 4,Void,Draw_GiveInputSourceRectangleUV1,MinU,Float32,MaxU,Float32,MinV,Float32,MaxV,Float32) \
	SUBMACRO##_4(Offset_Draw + 5,Void,Draw_GiveInputSourceRectangleUV2,MinU,Float32,MaxU,Float32,MinV,Float32,MaxV,Float32) \
	\
	SUBMACRO##_1(Offset_Physics + 0,Void,Physics_Step,TimeStep,Float32) \
	SUBMACRO##_3(Offset_Physics + 1,Void,Physics_SetGravity,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_0(Offset_Physics + 2,Void,Physics_GetGravity_OutV3) \
	SUBMACRO##_1(Offset_Physics + 3,Void,Physics_SetDebugDrawRadius,NewValue,Float32) \
	SUBMACRO##_0(Offset_Physics + 4,Float32,Physics_GetDebugDrawRadius) \
	SUBMACRO##_0(Offset_Physics + 5,Void,Physics_LetInstancesFollowRigidBodies) \
	SUBMACRO##_1(Offset_Physics + 6,Void,Physics_LetInstancesFollowRigidBodies_Interpolated,TimeOffset,Float32) \
	SUBMACRO##_1(Offset_Physics + 7,Int32,Physics_GetAllContactsFromLastStep_OutCB,IncludeContactsFromSleepingBodies,Boolean) \
	SUBMACRO##_1(Offset_Physics + 8,Int32,Physics_GetAllPairSumContactsFromLastStep_OutCB,IncludeContactsFromSleepingBodies,Boolean) \
	\
	SUBMACRO##_1(Offset_Physics_Constraint + 0,Void,Constraint_Delete,Constraint,Int32) \
	SUBMACRO##_4(Offset_Physics_Constraint + 1,Int32,Constraint_Create_PointToPoint_1,RigidBody,Int32,Point_X,Float32,Point_Y,Float32,Point_Z,Float32) \
	SUBMACRO##_8(Offset_Physics_Constraint + 2,Int32,Constraint_Create_PointToPoint_2,RigidBodyA,Int32,RigidBodyB,Int32,PointA_X,Float32,PointA_Y,Float32,PointA_Z,Float32,PointB_X,Float32,PointB_Y,Float32,PointB_Z,Float32) \
	SUBMACRO##_7(Offset_Physics_Constraint + 3,Int32,Constraint_Create_Hinge_1,RigidBody,Int32,Pivot_X,Float32,Pivot_Y,Float32,Pivot_Z,Float32,Axis_X,Float32,Axis_Y,Float32,Axis_Z,Float32) \
	SUBMACRO##_14(Offset_Physics_Constraint + 4,Int32,Constraint_Create_Hinge_2,RigidBodyA,Int32,RigidBodyB,Int32,PivotA_X,Float32,PivotA_Y,Float32,PivotA_Z,Float32,PivotB_X,Float32,PivotB_Y,Float32,PivotB_Z,Float32,AxisA_X,Float32,AxisA_Y,Float32,AxisA_Z,Float32,AxisB_X,Float32,AxisB_Y,Float32,AxisB_Z,Float32) \
	SUBMACRO##_2(Offset_Physics_Constraint + 5,Void,Constraint_SetEnabled,Constraint,Int32, Enabled, Boolean) \
	SUBMACRO##_1(Offset_Physics_Constraint + 6,Int32,Constraint_IsEnabled,Constraint,Int32) \
	SUBMACRO##_2(Offset_Physics_Constraint + 7,Void,Constraint_Hinge_Motor_Enable,Constraint,Int32,Enabled,Boolean) \
	SUBMACRO##_1(Offset_Physics_Constraint + 8,Int32,Constraint_Hinge_Motor_IsEnabled,Constraint,Int32) \
	SUBMACRO##_4(Offset_Physics_Constraint + 9,Void,Constraint_Hinge_Motor_Control,Constraint,Int32,Enabled,Boolean,TargetVelocity,Float32,MaxImpulse,Float32) \
	SUBMACRO##_1(Offset_Physics_Constraint + 10,Int32,Constraint_GetRigidBodyA,Constraint,Int32) \
	SUBMACRO##_1(Offset_Physics_Constraint + 11,Int32,Constraint_GetRigidBodyB,Constraint,Int32) \
	\
	SUBMACRO##_1(Offset_Physics_RigidBody + 0,Void,RigidBody_Delete,RigidBody,Int32) \
	SUBMACRO##_10(Offset_Physics_RigidBody + 1,Int32,RigidBody_Create_Static,CollisionShape,Int32,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,XAxis_X,Float32,XAxis_Y,Float32,XAxis_Z,Float32,YAxis_X,Float32,YAxis_Y,Float32,YAxis_Z,Float32) \
	SUBMACRO##_11(Offset_Physics_RigidBody + 2,Int32,RigidBody_Create_Dynamic,CollisionShape,Int32,Mass,Float32,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,XAxis_X,Float32,XAxis_Y,Float32,XAxis_Z,Float32,YAxis_X,Float32,YAxis_Y,Float32,YAxis_Z,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 3,Void,RigidBody_GetTransformation_OutM4,RigidBody,Int32) \
	SUBMACRO##_10(Offset_Physics_RigidBody + 4,Void,RigidBody_SetTransformation,RigidBody,Int32,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,XAxis_X,Float32,XAxis_Y,Float32,XAxis_Z,Float32,YAxis_X,Float32,YAxis_Y,Float32,YAxis_Z,Float32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 5,Void,RigidBody_SetLinearSleepingThreshold,RigidBody,Int32,LinearTreshold,Float32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 6,Void,RigidBody_SetAngularSleepingThreshold,RigidBody,Int32,AngularTreshold,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 7,Float32,RigidBody_GetLinearSleepingThreshold,RigidBody,Int32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 8,Float32,RigidBody_GetAngularSleepingThreshold,RigidBody,Int32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 9,Int32,RigidBody_GetActivationState,RigidBody,Int32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 10,Void,RigidBody_GetBoundingBoxMinimum_OutV3,RigidBody,Int32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 11,Void,RigidBody_GetBoundingBoxMaximum_OutV3,RigidBody,Int32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 12,Void,RigidBody_Dynamic_ApplyForce_Linear,RigidBody,Int32,Acc_X,Float32,Acc_Y,Float32,Acc_Z,Float32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 13,Void,RigidBody_Dynamic_ApplyForce_Angular,RigidBody,Int32,Acc_X,Float32,Acc_Y,Float32,Acc_Z,Float32) \
	SUBMACRO##_7(Offset_Physics_RigidBody + 14,Void,RigidBody_Dynamic_ApplyForce_Point,RigidBody,Int32,Acc_X,Float32,Acc_Y,Float32,Acc_Z,Float32,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 15,Void,RigidBody_Dynamic_ApplyImpulse_Linear,RigidBody,Int32,Vel_X,Float32,Vel_Y,Float32,Vel_Z,Float32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 16,Void,RigidBody_Dynamic_ApplyImpulse_Angular,RigidBody,Int32,Vel_X,Float32,Vel_Y,Float32,Vel_Z,Float32) \
	SUBMACRO##_7(Offset_Physics_RigidBody + 17,Void,RigidBody_Dynamic_ApplyImpulse_Point,RigidBody,Int32,Vel_X,Float32,Vel_Y,Float32,Vel_Z,Float32,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 18,Void,RigidBody_SetLinearDamping,RigidBody,Int32,LinearDamping,Float32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 19,Void,RigidBody_SetAngularDamping,RigidBody,Int32,AngularDamping,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 20,Float32,RigidBody_GetLinearDamping,RigidBody,Int32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 21,Float32,RigidBody_GetAngularDamping,RigidBody,Int32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 22,Void,RigidBody_GetLinearVelocity_OutV3,RigidBody,Int32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 23,Void,RigidBody_GetAngularVelocity_OutV3,RigidBody,Int32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 24,Void,RigidBody_SetLinearVelocity,RigidBody,Int32,Vel_X,Float32,Vel_Y,Float32,Vel_Z,Float32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 25,Void,RigidBody_SetAngularVelocity,RigidBody,Int32,Vel_X,Float32,Vel_Y,Float32,Vel_Z,Float32) \
	SUBMACRO##_10(Offset_Physics_RigidBody + 26,Int32,RigidBody_Create_Kinematic,CollisionShape,Int32,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,XAxis_X,Float32,XAxis_Y,Float32,XAxis_Z,Float32,YAxis_X,Float32,YAxis_Y,Float32,YAxis_Z,Float32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 27,Void,RigidBody_SetActivationState,RigidBody,Int32,ActivationState,Int32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 28,Void,RigidBody_SetFriction,RigidBody,Int32,Friction,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 29,Float32,RigidBody_GetFriction,RigidBody,Int32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 30,Void,RigidBody_SetAnisotropicFriction,RigidBody,Int32,Friction_X,Float32,Friction_Y,Float32,Friction_Z,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 31,Void,RigidBody_GetAnisotropicFriction_OutV3,RigidBody,Int32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 32,Void,RigidBody_SetContinuousCollisionDetectionMotionTreshold,RigidBody,Int32,Treshold,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 33,Float32,RigidBody_GetContinuousCollisionDetectionMotionTreshold,RigidBody,Int32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 34,Void,RigidBody_Dynamic_SetLinearMass,RigidBody,Int32,LinearMass,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 35,Float32,RigidBody_GetLinearMass,RigidBody,Int32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 36,Void,RigidBody_Dynamic_SetLocalInertia,RigidBody,Int32,LocalInertia_X,Float32,LocalInertia_Y,Float32,LocalInertia_Z,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 37,Void,RigidBody_GetLocalInertia_OutV3,RigidBody,Int32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 38,Void,RigidBody_GetTransformation_Interpolated_OutM4,RigidBody,Int32,TimeOffset,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 39,Int32,RigidBody_GetCollisionPointsFromBody_OutCB,RigidBody,Int32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 40,Int32,RigidBody_GetCollisionPointsBetweenBodies_OutCB,RigidBodyA,Int32,RigidBodyB,Int32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 41,Void,RigidBody_GetVelocityAtPoint_OutV3,RigidBody,Int32,WorldSpacePoint_X,Float32,WorldSpacePoint_Y,Float32,WorldSpacePoint_Z,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 42,Int32,RigidBody_GetCollisionShape,RigidBody,Int32) \
	SUBMACRO##_4(Offset_Physics_RigidBody + 43,Void,RigidBody_SetPosition,RigidBody,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 44,Void,RigidBody_GetPosition_OutV3,RigidBody,Int32) \
	SUBMACRO##_3(Offset_Physics_RigidBody + 45,Void,RigidBody_SetUserData,RigidBody,Int32,Index,Int32,NewValue,Int32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 46,Int32,RigidBody_GetUserData,RigidBody,Int32,Index,Int32) \
	SUBMACRO##_2(Offset_Physics_RigidBody + 47,Void,RigidBody_SetRestitution,RigidBody,Int32,Restitution,Float32) \
	SUBMACRO##_1(Offset_Physics_RigidBody + 48,Float32,RigidBody_GetRestitution,RigidBody,Int32) \
	SUBMACRO##_7(Offset_Physics_RigidBody + 49,Int32,RigidBody_GetFirstIntersection_Out2V3,Start_X,Float32,Start_Y,Float32,Start_Z,Float32,End_X,Float32,End_Y,Float32,End_Z,Float32,RigidBody,Int32) \
	\
	SUBMACRO##_1(Offset_Physics_CollisionShape + 0,Void,CollisionShape_Delete,CollisionShape,Int32) \
	SUBMACRO##_3(Offset_Physics_CollisionShape + 1,Int32,CollisionShape_Create_Box,HalfWidth,Float32,HalfHeight,Float32,HalfDepth,Float32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 2,Int32,CollisionShape_Create_Sphere,Radius,Float32) \
	SUBMACRO##_4(Offset_Physics_CollisionShape + 3,Int32,CollisionShape_Create_StaticPlane,NX,Float32,NY,Float32,NZ,Float32,D,Float32) \
	SUBMACRO##_3(Offset_Physics_CollisionShape + 4,Int32,CollisionShape_Create_Cylinder,HalfWidth,Float32,HalfHeight,Float32,HalfDepth,Float32) \
	SUBMACRO##_2(Offset_Physics_CollisionShape + 5,Int32,CollisionShape_Create_Capsule,Radius,Float32,HalfHeight,Float32) \
	SUBMACRO##_2(Offset_Physics_CollisionShape + 6,Int32,CollisionShape_Create_Cone,Radius,Float32,HalfHeight,Float32) \
	SUBMACRO##_6(Offset_Physics_CollisionShape + 7,Int32,CollisionShape_Create_HeightField_UsingCPUSurface,CPUSurface,Int32,UpDimension,Int32,ChannelIndex,Int32,HalfBoundHeight,Float32,FlipQuadEdges,Boolean,DiamondPattern,Boolean) \
	SUBMACRO##_4(Offset_Physics_CollisionShape + 8,Void,CollisionShape_SetLocalScaling,CollisionShape,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 9,Void,CollisionShape_GetLocalScaling_OutV3,CollisionShape,Int32) \
	SUBMACRO##_0(Offset_Physics_CollisionShape + 10,Int32,CollisionShape_Create_Compound) \
	SUBMACRO##_11(Offset_Physics_CollisionShape + 11,Void,CollisionShape_Compound_AddChild,CompoundShape,Int32,ChildShape,Int32,Pos_X,Float32,Pos_Y,Float32,Pos_Z,Float32,XAxis_X,Float32,XAxis_Y,Float32,XAxis_Z,Float32,YAxis_X,Float32,YAxis_Y,Float32,YAxis_Z,Float32) \
	SUBMACRO##_0(Offset_Physics_CollisionShape + 12,Int32,CollisionShape_Create_ConvexHull) \
	SUBMACRO##_5(Offset_Physics_CollisionShape + 13,Int32,CollisionShape_Create_ConvexHull_FromModel,Model,Int32,DetailLevel,Int32,Quality,Int32,WeldingTreshold,Float32,UseVertexSelection,Boolean) \
	SUBMACRO##_4(Offset_Physics_CollisionShape + 14,Void,CollisionShape_ConvexHull_AddPoint,ConvexHullShape,Int32,X,Float32,Y,Float32,Z,Float32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 15,Int32,CollisionShape_ConvexHull_GetNumberOfPoints,ConvexHullShape,Int32) \
	SUBMACRO##_2(Offset_Physics_CollisionShape + 16,Void,CollisionShape_ConvexHull_GetPoint_OutV3,ConvexHullShape,Int32,Index,Int32) \
	SUBMACRO##_3(Offset_Physics_CollisionShape + 18,Void,CollisionShape_ConvexHull_Optimize,ConvexHullShape,Int32,Quality,Int32,WeldingTreshold,Float32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 19,Int32,CollisionShape_ConvexHull_MakeCopy,OldConvexHullShape,Int32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 20,Void,CollisionShape_GetLocalInertiaPerMass_OutV3,CollisionShape,Int32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 22,Float32,CollisionShape_GetRadius,CollisionShape,Int32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 24,Float32,CollisionShape_GetHalfWidth,CollisionShape,Int32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 26,Float32,CollisionShape_GetHalfHeight,CollisionShape,Int32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 28,Float32,CollisionShape_GetHalfDepth,CollisionShape,Int32) \
	SUBMACRO##_1(Offset_Physics_CollisionShape + 29,Int32,CollisionShape_GetNumberOfChildren,CollisionShape,Int32) \
	SUBMACRO##_2(Offset_Physics_CollisionShape + 30,Int32,CollisionShape_Compound_GetChild_OutM4,CompoundShape,Int32,Index,Int32)
