
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

int CDFPGECtrl::BoneFrame_CreateEmpty(void) {
	int Result;
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running) {
			Result = DGE.IDFromPointer(DGE.BoneFrame_CreateEmpty());
		} else {
			REPORT_NOT_RUNNING(L"BoneFrame_CreateEmpty")
			Result = 0;
		}
	)
	return Result;
}

int CDFPGECtrl::BoneFrame_CreateFromDefaultPose(int Model) {
	int Result;
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(Model,Model)
		if BAD_REF(Model) {
			REPORT_TYPE(Model,L"BoneFrame_CreateFromDefaultPose",Model)
			Result = 0;
		} else {
			Result = DGE.IDFromPointer(DGE.BoneFrame_CreateFromDefaultPose(pModel));
		}
	)
	return Result;
}

void CDFPGECtrl::BoneFrame_Delete(int BoneFrame) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(BoneFrame,BoneFrame)
		if BAD_REF(BoneFrame) {
			REPORT_TYPE(BoneFrame,L"BoneFrame_Delete",BoneFrame)
		} else {
			DGE.Delete_BoneFrame(pBoneFrame);
		}
	)
}

void CDFPGECtrl::BoneFrame_GetPosition_OutV3(int BoneFrame, int BoneIndex) {
	CRITICAL_CODE_SECTION(
		ClearMatrixBuffer();
		GET_FROM_REF(BoneFrame,BoneFrame)
		if BAD_REF(BoneFrame) {
			REPORT_TYPE(BoneFrame,L"BoneFrame_GetPosition_OutV3",BoneFrame)
		} else if (BoneIndex < 0 || BoneIndex > MaxNumberOfBones - 1) {
			swprintf_s( MQ->messageBuffer, L"BoneFrame_GetPosition_OutV3: BoneIndex %i was out of the constant bound [0..%i].",BoneIndex,MaxNumberOfBones - 1); MQ->InsertMessage(MQ->messageBuffer);
		} else {
			SetVector3ToMB(V4_TO_V3(pBoneFrame->Content.Bone[BoneIndex].Start));
		}
	)
}

void CDFPGECtrl::BoneFrame_SetPosition(int BoneFrame, int BoneIndex, float X, float Y, float Z) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(BoneFrame,BoneFrame)
		if BAD_REF(BoneFrame) {
			REPORT_TYPE(BoneFrame,L"BoneFrame_SetPosition",BoneFrame)
		} else if (BoneIndex < 0 || BoneIndex > MaxNumberOfBones - 1) {
			swprintf_s( MQ->messageBuffer, L"BoneFrame_SetPosition: BoneIndex %i was out of the constant bound [0..%i].",BoneIndex,MaxNumberOfBones - 1); MQ->InsertMessage(MQ->messageBuffer);
		} else {
			SET_XYZ_IN_V4(pBoneFrame->Content.Bone[BoneIndex].Start,X,Y,Z)
		}
	)
}

void CDFPGECtrl::BoneFrame_GetYAxis_OutV3(int BoneFrame, int BoneIndex) {
	CRITICAL_CODE_SECTION(
		ClearMatrixBuffer();
		GET_FROM_REF(BoneFrame,BoneFrame)
		if BAD_REF(BoneFrame) {
			REPORT_TYPE(BoneFrame,L"BoneFrame_GetYAxis_OutV3",BoneFrame)
		} else if (BoneIndex < 0 || BoneIndex > MaxNumberOfBones - 1) {
			swprintf_s( MQ->messageBuffer, L"BoneFrame_GetYAxis_OutV3: BoneIndex %i was out of the constant bound [0..%i].",BoneIndex,MaxNumberOfBones - 1); MQ->InsertMessage(MQ->messageBuffer);
		} else {
			SetVector3ToMB(V4_TO_V3(pBoneFrame->Content.Bone[BoneIndex].YAxis));
		}
	)
}

void CDFPGECtrl::BoneFrame_SetYAxis(int BoneFrame, int BoneIndex, float X, float Y, float Z) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(BoneFrame,BoneFrame)
		if BAD_REF(BoneFrame) {
			REPORT_TYPE(BoneFrame,L"BoneFrame_SetYAxis",BoneFrame)
		} else if (BoneIndex < 0 || BoneIndex > MaxNumberOfBones - 1) {
			swprintf_s( MQ->messageBuffer, L"BoneFrame_SetYAxis: BoneIndex %i was out of the constant bound [0..%i].",BoneIndex,MaxNumberOfBones - 1); MQ->InsertMessage(MQ->messageBuffer);
		} else {
			SET_XYZ_IN_V4(pBoneFrame->Content.Bone[BoneIndex].YAxis,X,Y,Z)
		}
	)
}

void CDFPGECtrl::BoneFrame_GetZAxis_OutV3(int BoneFrame, int BoneIndex) {
	CRITICAL_CODE_SECTION(
		ClearMatrixBuffer();
		GET_FROM_REF(BoneFrame,BoneFrame)
		if BAD_REF(BoneFrame) {
			REPORT_TYPE(BoneFrame,L"BoneFrame_GetZAxis_OutV3",BoneFrame)
		} else if (BoneIndex < 0 || BoneIndex > MaxNumberOfBones - 1) {
			swprintf_s( MQ->messageBuffer, L"BoneFrame_GetZAxis_OutV3: BoneIndex %i was out of the constant bound [0..%i].",BoneIndex,MaxNumberOfBones - 1); MQ->InsertMessage(MQ->messageBuffer);
		} else {
			SetVector3ToMB(V4_TO_V3(pBoneFrame->Content.Bone[BoneIndex].ZAxis));
		}
	)
}

void CDFPGECtrl::BoneFrame_SetZAxis(int BoneFrame, int BoneIndex, float X, float Y, float Z) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(BoneFrame,BoneFrame)
		if BAD_REF(BoneFrame) {
			REPORT_TYPE(BoneFrame,L"BoneFrame_SetZAxis",BoneFrame)
		} else if (BoneIndex < 0 || BoneIndex > MaxNumberOfBones - 1) {
			swprintf_s( MQ->messageBuffer, L"BoneFrame_SetZAxis: BoneIndex %i was out of the constant bound [0..%i].",BoneIndex,MaxNumberOfBones - 1); MQ->InsertMessage(MQ->messageBuffer);
		} else {
			SET_XYZ_IN_V4(pBoneFrame->Content.Bone[BoneIndex].ZAxis,X,Y,Z)
		}
	)
}

void CDFPGECtrl::BoneFrame_GetUserData_OutV3(int BoneFrame, int BoneIndex) {
	CRITICAL_CODE_SECTION(
		ClearMatrixBuffer();
		GET_FROM_REF(BoneFrame,BoneFrame)
		if BAD_REF(BoneFrame) {
			REPORT_TYPE(BoneFrame,L"BoneFrame_GetUserData_OutV3",BoneFrame)
		} else if (BoneIndex < 0 || BoneIndex > MaxNumberOfBones - 1) {
			swprintf_s( MQ->messageBuffer, L"BoneFrame_GetUserData_OutV3: BoneIndex %i was out of the constant bound [0..%i].",BoneIndex,MaxNumberOfBones - 1); MQ->InsertMessage(MQ->messageBuffer);
		} else {
			SetVector3ToMB(DVector3(pBoneFrame->Content.Bone[BoneIndex].Start.w,pBoneFrame->Content.Bone[BoneIndex].YAxis.w,pBoneFrame->Content.Bone[BoneIndex].ZAxis.w));
		}
	)
}

void CDFPGECtrl::BoneFrame_SetUserData(int BoneFrame, int BoneIndex, float X, float Y, float Z) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(BoneFrame,BoneFrame)
		if BAD_REF(BoneFrame) {
			REPORT_TYPE(BoneFrame,L"BoneFrame_SetUserData",BoneFrame)
		} else if (BoneIndex < 0 || BoneIndex > MaxNumberOfBones - 1) {
			swprintf_s( MQ->messageBuffer, L"BoneFrame_SetUserData: BoneIndex %i was out of the constant bound [0..%i].",BoneIndex,MaxNumberOfBones - 1); MQ->InsertMessage(MQ->messageBuffer);
		} else {
			pBoneFrame->Content.Bone[BoneIndex].Start.w = X;
			pBoneFrame->Content.Bone[BoneIndex].YAxis.w = Y;
			pBoneFrame->Content.Bone[BoneIndex].ZAxis.w = Z;
		}
	)
}
