
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

int CDFPGECtrl::CPUSurface_CreateFixed(int newWidth, int newHeight, float Red, float Green, float Blue, float Alpha) {
	CRITICAL_CODE_SECTION(
		int Result;
		if (DGE.m_Running) {
			Result = DGE.IDFromPointer(DGE.CPUSurface_CreateFixed(newWidth,newHeight,Red,Green,Blue,Alpha));
		} else {
			REPORT_NOT_RUNNING(L"CPUSurface_CreateFixed")
			Result = 0;
		}
	)
	return Result;
}

void CDFPGECtrl::CPUSurface_Delete(int CPUSurface) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(CPUSurface,CPUSurface);
		if (pCPUSurface == NULL) {
			REPORT_TYPE(CPUSurface,L"CPUSurface_Delete",CPUSurface)
		} else {
			DGE.Delete_CPUSurface(pCPUSurface);
		}
	)
}

int CDFPGECtrl::CPUSurface_GetWidth(int CPUSurface) {
	CRITICAL_CODE_SECTION(
		int Result;
		GET_FROM_REF(CPUSurface,CPUSurface);
		if (pCPUSurface == NULL) {
			REPORT_TYPE(CPUSurface,L"CPUSurface_GetWidth",CPUSurface)
			Result = 0;
		} else {
			Result = pCPUSurface->Width;
		}
	)
	return Result;
}

int CDFPGECtrl::CPUSurface_GetHeight(int CPUSurface) {
	CRITICAL_CODE_SECTION(
		int Result;
		GET_FROM_REF(CPUSurface,CPUSurface);
		if (pCPUSurface == NULL) {
			REPORT_TYPE(CPUSurface,L"CPUSurface_GetHeight",CPUSurface)
			Result = 0;
		} else {
			Result = pCPUSurface->Height;
		}
	)
	return Result;
}

void CDFPGECtrl::CPUSurface_GetPixelColor_Clamped_OutV4(int CPUSurface, int X, int Y) {
	CRITICAL_CODE_SECTION(
		DVector4 ColorOutput;
		GET_FROM_REF(CPUSurface,CPUSurface);
		ClearMatrixBuffer();
		if (pCPUSurface == NULL) {
			REPORT_TYPE(CPUSurface,L"CPUSurface_GetPixelColor_Clamped_OutV4",CPUSurface)
		} else {
			SetVector4ToMB(DGE.CPUSurface_GetPixelColor_Clamped(pCPUSurface,X,Y));
		}
	)
}

void CDFPGECtrl::CPUSurface_GetPixelColor_Border_OutV4(int CPUSurface, int X, int Y, float DefaultRed, float DefaultGreen, float DefaultBlue, float DefaultAlpha) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(CPUSurface,CPUSurface);
		ClearMatrixBuffer();
		if (pCPUSurface == NULL) {
			REPORT_TYPE(CPUSurface,L"CPUSurface_GetPixelColor_Border_OutV4",CPUSurface)
		} else {
			SetVector4ToMB(DGE.CPUSurface_GetPixelColor_Border(pCPUSurface,X,Y,DefaultRed,DefaultGreen,DefaultBlue,DefaultAlpha));
		}
	)
}

void CDFPGECtrl::CPUSurface_SetPixelColor_Ignore(int CPUSurface, int X, int Y, float Red, float Green, float Blue, float Alpha) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(CPUSurface,CPUSurface);
		if (pCPUSurface == NULL) {
			REPORT_TYPE(CPUSurface,L"CPUSurface_SetPixelColor_Ignore",CPUSurface)
		} else {
			DGE.CPUSurface_SetPixelColor(pCPUSurface,X,Y,Red,Green,Blue,Alpha,false);
		}
	)
}

void CDFPGECtrl::CPUSurface_SetPixelColor_Warning(int CPUSurface, int X, int Y, float Red, float Green, float Blue, float Alpha) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(CPUSurface,CPUSurface);
		if (pCPUSurface == NULL) {
			REPORT_TYPE(CPUSurface,L"CPUSurface_SetPixelColor_Warning",CPUSurface)
		} else {
			DGE.CPUSurface_SetPixelColor(pCPUSurface,X,Y,Red,Green,Blue,Alpha,true);
		}
	)
}

void CDFPGECtrl::CPUSurface_FillWithColor(int CPUSurface, float Red, float Green, float Blue, float Alpha) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(CPUSurface,CPUSurface);
		if (pCPUSurface == NULL) {
			REPORT_TYPE(CPUSurface,L"CPUSurface_FillWithColor",CPUSurface)
		} else {
			DGE.CPUSurface_FillWithColor(pCPUSurface,Red,Green,Blue,Alpha);
		}
	)
}

void CDFPGECtrl::CPUSurface_CopyRectFromDrawSurface(int Input_DrawSurface, int Output_CPUSurface, int SourceLeft, int SourceTop, int DestLeft, int DestTop, int Width, int Height) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(DrawSurface,Input_DrawSurface);
		GET_FROM_REF(CPUSurface,Output_CPUSurface);
		if (pInput_DrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"CPUSurface_CopyFromDrawSurface",Input_DrawSurface)
		} else if (pOutput_CPUSurface == NULL) {
			REPORT_TYPE(CPUSurface,L"CPUSurface_CopyFromDrawSurface",Output_CPUSurface)
		} else {
			DGE.CPUSurface_CopyRectFromDrawSurface(pInput_DrawSurface,pOutput_CPUSurface,SourceLeft,SourceTop,DestLeft,DestTop,Width,Height);
		}
	)
}
