
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

// It will reset all input so that the user don't have to worry about cleaning up.
void CDFPGECtrl::Draw_RenderQuad(int OutputSurface, int DrawShader, float Center_X, float Center_Y, float XAxis_X, float XAxis_Y, float YAxis_X, float YAxis_Y, int FilterType) {
	CRITICAL_CODE_SECTION(
		DrawSurface_Struct* pOutputSurface; pOutputSurface = DGE.DrawSurface_PointerFromID(OutputSurface,false);
		Shader_Struct* pDrawShader; pDrawShader = DGE.Shader_PointerFromID(DrawShader,false);
		if (pOutputSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"Draw_RenderShader",OutputSurface)
		} else if (pDrawShader == NULL) {
			REPORT_TYPE(Shader,L"Draw_RenderShader",DrawShader)
		} else if (pDrawShader->ShaderType != ShaderType_Draw) {
			MQ->InsertMessage(L"Draw_RenderShader: Draw is a shader but not a draw shader.");
		} else {
			// Negate the Y axis to enter coordinates more like texture space
			DGE.Draw_RenderQuad(pOutputSurface,pDrawShader,DVector2(Center_X,-Center_Y),DVector2(XAxis_X,-XAxis_Y),DVector2(YAxis_X,-YAxis_Y),FilterType);
		}
	)
}

void CDFPGECtrl::Draw_GiveInputSurface(int Index, int DrawSurfaceOrTexture) {
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running) {
			if (Index < 0 || Index > 15) {
				swprintf_s( MQ->messageBuffer, L"Draw_GiveInputSurface: Index %i was out of bound [0..15].",Index); MQ->InsertMessage(MQ->messageBuffer);
			} else if (DrawSurfaceOrTexture == 0) {
				swprintf_s( MQ->messageBuffer, L"Draw_GiveInputSurface: DrawSurfaceOrTexture is 0."); MQ->InsertMessage(MQ->messageBuffer);
			} else if (DrawSurfaceOrTexture < 0 || DrawSurfaceOrTexture > DGE.m_usedReferences) {
				swprintf_s( MQ->messageBuffer, L"Draw_GiveInputSurface: DrawSurfaceOrTexture is %i and outside of the ID table.", DrawSurfaceOrTexture); MQ->InsertMessage(MQ->messageBuffer);
			} else if (DGE.m_pReferences[DrawSurfaceOrTexture].Valid == false) {
				swprintf_s( MQ->messageBuffer, L"Draw_GiveInputSurface: DrawSurfaceOrTexture is %i and not a valid ID.", DrawSurfaceOrTexture); MQ->InsertMessage(MQ->messageBuffer);
			} else if (DGE.m_pReferences[DrawSurfaceOrTexture].CollectionType != ColType_Texture && DGE.m_pReferences[DrawSurfaceOrTexture].CollectionType != ColType_DrawSurface) {
				swprintf_s( MQ->messageBuffer, L"Draw_GiveInputSurface: DrawSurfaceOrTexture is %i and not texture or drawsurface.", DrawSurfaceOrTexture); MQ->InsertMessage(MQ->messageBuffer);
			} else {
				DGE.m_Draw_InputTextures[Index] = DrawSurfaceOrTexture;
			}
		} else {
			REPORT_NOT_RUNNING(L"Draw_GiveInputSurface")
		}
	)
}

void CDFPGECtrl::Draw_GiveInputVector(int Index, float X, float Y, float Z, float W) {
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running) {
			if (Index < 0 || Index > NumberOfUserVectorsPerDrawing) {
				swprintf_s( MQ->messageBuffer, L"Draw_GiveInputVector: Index %i was out of bound [0..%i].",Index,NumberOfUserVectorsPerDrawing); MQ->InsertMessage(MQ->messageBuffer);
			} else {
				DGE.m_Draw_InputArguments[Index].x = X;
				DGE.m_Draw_InputArguments[Index].y = Y;
				DGE.m_Draw_InputArguments[Index].z = Z;
				DGE.m_Draw_InputArguments[Index].w = W;
			}
		} else {
			REPORT_NOT_RUNNING(L"Draw_GiveInputVector")
		}
	)
}

void CDFPGECtrl::Draw_GiveInputColor(float R, float G, float B, float A) {
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running) {
			DGE.m_Draw_Color.x = R;
			DGE.m_Draw_Color.y = G;
			DGE.m_Draw_Color.z = B;
			DGE.m_Draw_Color.w = A;
		} else {
			REPORT_NOT_RUNNING(L"Draw_GiveInputColor")
		}
	)
}

void CDFPGECtrl::Draw_GiveInputSourceRectangleUV1(float MinU, float MaxU, float MinV, float MaxV) {
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running) {
			DGE.m_Draw_SrcRectUV1.x = MinU;
			DGE.m_Draw_SrcRectUV1.y = MaxU;
			DGE.m_Draw_SrcRectUV1.z = MinV;
			DGE.m_Draw_SrcRectUV1.w = MaxV;
		} else {
			REPORT_NOT_RUNNING(L"Draw_GiveInputSourceRectangleUV1")
		}
	)
}

void CDFPGECtrl::Draw_GiveInputSourceRectangleUV2(float MinU, float MaxU, float MinV, float MaxV) {
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running) {
			DGE.m_Draw_SrcRectUV2.x = MinU;
			DGE.m_Draw_SrcRectUV2.y = MaxU;
			DGE.m_Draw_SrcRectUV2.z = MinV;
			DGE.m_Draw_SrcRectUV2.w = MaxV;
		} else {
			REPORT_NOT_RUNNING(L"Draw_GiveInputSourceRectangleUV2")
		}
	)
}
