
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

// Replace with a fixed reference
int CDFPGECtrl::DrawSurface_GetFinalOutput(void) {
	CRITICAL_CODE_SECTION(
		int Result;
		if (DGE.m_Running) {
			Result = DGE.IDFromPointer(&DGE.m_SurfaceScreen);
		} else {
			REPORT_NOT_RUNNING(L"DrawSurface_GetFinalOutput")
			Result = 0;
		}
	)
	return Result;
}

int CDFPGECtrl::DrawSurface_CreateFixed(int newWidth, int newHeight, int numberOfDepthBuffers, bool useExtraColorBuffer) {
	CRITICAL_CODE_SECTION(
		int Result;
		if (DGE.m_Running == false) {
			REPORT_NOT_RUNNING(L"DrawSurface_CreateFixed")
			Result = 0;
		} else if (numberOfDepthBuffers < 0 || numberOfDepthBuffers > 2) {
			MQ->InsertMessage(L"DrawSurface_CreateFixed: numberOfDepthBuffers must be from 0 to 2.");
			Result = 0;
		} else if (newWidth < 1 || newHeight < 1 || newWidth > 8192 || newHeight > 8192) {
			MQ->InsertMessage(L"DrawSurface_CreateFixed: newWidth and newHeight must be from 1 to 8192.");
		} else {
			Result = DGE.IDFromPointer(DGE.DrawSurface_CreateFixed(newWidth,newHeight,numberOfDepthBuffers,useExtraColorBuffer));
		}
	)
	return Result;
}

int CDFPGECtrl::DrawSurface_CreateAutoSized(float widthMultiplier, float heightMultiplier, int widthAdder, int heightAdder, int numberOfDepthBuffers, bool useExtraColorBuffer) {
	CRITICAL_CODE_SECTION(
		int Result;
		if (DGE.m_Running == false) {
			REPORT_NOT_RUNNING(L"DrawSurface_CreateAutoSized")
			Result = 0;
		} else if (numberOfDepthBuffers < 0 || numberOfDepthBuffers > 2) {
			MQ->InsertMessage(L"DrawSurface_CreateAutoSized: numberOfDepthBuffers must be from 0 to 2.");
			Result = 0;
		} else if (widthAdder < 0 || heightAdder < 0 || widthAdder > 8192 || heightAdder > 8192) {
			MQ->InsertMessage(L"DrawSurface_CreateAutoSized: widthAdder and heightAdder must be from 0 to 8192.");
		} else {
			Result = DGE.IDFromPointer(DGE.DrawSurface_CreateAutoSized(widthMultiplier,heightMultiplier,widthAdder,heightAdder,numberOfDepthBuffers,useExtraColorBuffer));
		}
	)
	return Result;
}

void CDFPGECtrl::DrawSurface_Delete(int DrawSurface) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == &DGE.m_SurfaceScreen) {
			MQ->InsertMessage(L"DrawSurface_Delete: You can not delete the final draw surface.");
		} else if(pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_Delete",DrawSurface)
		} else {
			DGE.Delete_DrawSurface(pDrawSurface);
		}
	)
}

int CDFPGECtrl::DrawSurface_GetWidth(int DrawSurface) {
	CRITICAL_CODE_SECTION(
		int Result;
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_GetWidth",DrawSurface)
			Result = 0;
		} else {
			Result = DGE.DrawSurface_GetWidth(pDrawSurface);
		}
	)
	return Result;
}

int CDFPGECtrl::DrawSurface_GetHeight(int DrawSurface) {
	CRITICAL_CODE_SECTION(
		int Result;
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_GetHeight",DrawSurface)
			Result = 0;
		} else {
			Result = DGE.DrawSurface_GetHeight(pDrawSurface);
		}
	)
	return Result;
}

int CDFPGECtrl::DrawSurface_IsAutoSized(int DrawSurface) {
	CRITICAL_CODE_SECTION(
		int Result;
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_IsAutoSized",DrawSurface)
			Result = 0;
		} else if (pDrawSurface->AutoSize) {
			Result = 1;
		} else {
			Result = 0;
		}
	)
	return Result;
}

int CDFPGECtrl::DrawSurface_GetNumberOfDepthBuffers(int DrawSurface) {
	CRITICAL_CODE_SECTION(
		int Result;
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_GetNumberOfDepthBuffers",DrawSurface)
			Result = 0;
		} else {
			Result = pDrawSurface->DepthBuffers;
		}
	)
	return Result;
}

int CDFPGECtrl::DrawSurface_HasExtraColorBuffer(int DrawSurface) {
	CRITICAL_CODE_SECTION(
		int Result;
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_HasExtraColorBuffer",DrawSurface)
			Result = 0;
		} else if (pDrawSurface->HaveExtraColorBuffer) {
			Result = 1;
		} else {
			Result = 0;
		}
	)
	return Result;
}

int CDFPGECtrl::DrawSurface_SaveToFile_InSB(int DrawSurface) {
	CRITICAL_CODE_SECTION(
		int Result;
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_SaveToFile_InSB",DrawSurface)
			Result = 0;
		} else if (pDrawSurface == &DGE.m_SurfaceScreen) {
			MQ->InsertMessage(L"DrawSurface_SaveToFile_InSB: You can't save the content of the final draw surface because it does not work like other draw surfaces.");
			Result = 0;
		} else {
			Result = DGE.DrawSurface_SaveToFile(pDrawSurface,StringBuffer);
			if (Result == 0) {
				swprintf_s( MQ->messageBuffer, L"DrawSurface_SaveToFile_InSB: \"%s\" could not be saved. Make sure that the filename is correct and that you may write to that location.", StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
			} else if (Result == 2) {
				swprintf_s( MQ->messageBuffer, L"DrawSurface_SaveToFile_InSB: The filename in the string buffer must end with \".DDS\", \".BMP\", \".PNG\" or \".JPG\". \"%s\" does not have a supported file extension.", StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
				Result = 0;
			}
		}
	)
	return Result;
}

void CDFPGECtrl::DrawSurface_FillWithColor(int DrawSurface, float Red, float Green, float Blue, float Alpha) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_FillWithColor",DrawSurface)
		} else {
			DGE.DrawSurface_FillWithColor(pDrawSurface,Red,Green,Blue,Alpha);
			pDrawSurface->HasContent = true;
		}
	)
}

void CDFPGECtrl::DrawSurface_ClearDepthBuffer(int DrawSurface) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_ClearDepthBuffer",DrawSurface)
		} else {
			DGE.DrawSurface_ClearDepthBuffer(pDrawSurface);
			pDrawSurface->HasContent = true;
		}
	)
}

void CDFPGECtrl::DrawSurface_GetPixelColor_OutV4(int DrawSurface, int X, int Y) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(DrawSurface,DrawSurface);
		ClearMatrixBuffer();
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_GetPixelColor_OutV4",DrawSurface)
		} else {
			SetVector4ToMB(DGE.DrawSurface_GetPixelColor(pDrawSurface,X,Y));
		}
	)
}

void CDFPGECtrl::DrawSurface_SetPixelColor(int DrawSurface, int X, int Y, float Red, float Green, float Blue, float Alpha) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(DrawSurface,DrawSurface);
		if (pDrawSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"DrawSurface_SetPixelColor",DrawSurface)
		} else {
			DGE.DrawSurface_SetPixelColor(pDrawSurface,X,Y,DVector4(Red,Green,Blue,Alpha));
		}
	)
}
