
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

void CDFPGECtrl::Enviroment_GetBackgroundColor_OutV4(void) {
	CRITICAL_CODE_SECTION(
		ClearMatrixBuffer();
		SetVector4ToMB(DGE.m_vBackgroundColor);
	)
}

void CDFPGECtrl::Enviroment_SetBackgroundColor(float Red, float Green, float Blue, float Alpha) {
	CRITICAL_CODE_SECTION(
		DGE.m_vBackgroundColor = DVector4(Red,Green,Blue,Alpha);
	)
}

float CDFPGECtrl::Enviroment_GetFarClipPlane(void) {
	float Result;
	CRITICAL_CODE_SECTION(
		Result = DGE.m_FarClipPlane;
	)
	return Result;
}

void CDFPGECtrl::Enviroment_SetFarClipPlane(float NewValue) {
	CRITICAL_CODE_SECTION(
		DGE.m_FarClipPlane = NewValue;
	)
}

float CDFPGECtrl::Enviroment_GetNearClipPlane(void) {
	float Result;
	CRITICAL_CODE_SECTION(
		Result = DGE.m_NearClipPlane;
	)
	return Result;
}

void CDFPGECtrl::Enviroment_SetNearClipPlane(float NewValue) {
	CRITICAL_CODE_SECTION(
		DGE.m_NearClipPlane = NewValue;
	)
}

float CDFPGECtrl::Enviroment_GetMaxFogIntensity(void) {
	float Result;
	CRITICAL_CODE_SECTION(
		Result = DGE.m_MaxFogIntensity;
	)
	return Result;
}

void CDFPGECtrl::Enviroment_SetMaxFogIntensity(float NewValue) {
	CRITICAL_CODE_SECTION(
		DGE.m_MaxFogIntensity = NewValue;
	)
}

float CDFPGECtrl::Enviroment_GetMediumHighDetailLimit(void) {
	float Result;
	CRITICAL_CODE_SECTION(
		Result = DGE.m_MediumHighDetailLimit;
	)
	return Result;
}

void CDFPGECtrl::Enviroment_SetMediumHighDetailLimit(float NewValue) {
	CRITICAL_CODE_SECTION(
		DGE.m_MediumHighDetailLimit = NewValue;
	)
}

float CDFPGECtrl::Enviroment_GetLowMediumDetailLimit(void) {
	float Result;
	CRITICAL_CODE_SECTION(
		Result = DGE.m_LowMediumDetailLimit;
	)
	return Result;
}

void CDFPGECtrl::Enviroment_SetLowMediumDetailLimit(float NewValue) {
	CRITICAL_CODE_SECTION(
		DGE.m_LowMediumDetailLimit = NewValue;
	)
}

void CDFPGECtrl::Enviroment_UpdateAutomaticDetailLevels(float X, float Y, float Z) {
	CRITICAL_CODE_SECTION(
		DGE.UpdateAutomaticDetailLevels(DVector3(X,Y,Z));
	)
}

void CDFPGECtrl::Enviroment_UseAsSkyInstance(int Instance) {
	CRITICAL_CODE_SECTION(
		if (Instance == 0) {
			DGE.SetSkyInstance(NULL);
		} else {
			GET_FROM_REF(Instance,Instance)
			if BAD_REF(Instance) {
				REPORT_TYPE(Shader,L"Enviroment_UseAsSkyInstance",Instance)
			} else {
				DGE.SetSkyInstance(pInstance);
			}
		}
	)
}