
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

// It will reset all input so that the user don't have to worry about cleaning up.
void CDFPGECtrl::PostEffect_RenderShader(int OutputSurface, int PostEffect) {
	CRITICAL_CODE_SECTION(
		DrawSurface_Struct* pOutputSurface; pOutputSurface = DGE.DrawSurface_PointerFromID(OutputSurface,false);
		Shader_Struct* pPostEffect; pPostEffect = DGE.Shader_PointerFromID(PostEffect,false);
		if (pOutputSurface == NULL) {
			REPORT_TYPE(DrawSurface,L"PostEffect_RenderShader",OutputSurface)
		} else if (pPostEffect == NULL) {
			REPORT_TYPE(Shader,L"PostEffect_RenderShader",PostEffect)
		} else if (pPostEffect->ShaderType != ShaderType_PostEffect) {
			MQ->InsertMessage(L"PostEffect_RenderShader: PostEffect is a shader but not a post effect shader.");
		} else {
			DGE.PostEffect_RenderShader(pOutputSurface,pPostEffect);
		}
	)
}

void CDFPGECtrl::PostEffect_GiveInputSurface(int Index, int DrawSurfaceOrTexture, int SubresourceType) {
	CRITICAL_CODE_SECTION(
		if (SubresourceType < 0 || LastSubresourceType > 1) {
			MQ->InsertMessage(L"PostEffect_GiveInputSurface: SubresourceType must be 0 for reading the color or 1 for reading the depth.");
		} else if (DGE.m_Running) {
			if (Index < 0 || Index > 15) {
				swprintf_s( MQ->messageBuffer, L"PostEffect_GiveInputSurface: Index %i was out of bound [0..15].",Index); MQ->InsertMessage(MQ->messageBuffer);
			} else if (DrawSurfaceOrTexture == 0){
				swprintf_s( MQ->messageBuffer, L"PostEffect_GiveInputSurface: DrawSurfaceOrTexture is 0."); MQ->InsertMessage(MQ->messageBuffer);
			} else if (DrawSurfaceOrTexture < 0 || DrawSurfaceOrTexture > DGE.m_usedReferences){
				swprintf_s( MQ->messageBuffer, L"PostEffect_GiveInputSurface: DrawSurfaceOrTexture is %i and outside of the ID table.", DrawSurfaceOrTexture); MQ->InsertMessage(MQ->messageBuffer);
			} else if (DGE.m_pReferences[DrawSurfaceOrTexture].Valid == false){
				swprintf_s( MQ->messageBuffer, L"PostEffect_GiveInputSurface: DrawSurfaceOrTexture is %i and not a valid ID.", DrawSurfaceOrTexture); MQ->InsertMessage(MQ->messageBuffer);
			} else if (DGE.m_pReferences[DrawSurfaceOrTexture].CollectionType != ColType_Texture && DGE.m_pReferences[DrawSurfaceOrTexture].CollectionType != ColType_DrawSurface) {
				swprintf_s( MQ->messageBuffer, L"Draw_GiveInputSurface: DrawSurfaceOrTexture is %i and not texture or drawsurface.", DrawSurfaceOrTexture); MQ->InsertMessage(MQ->messageBuffer);
			} else {
				DGE.m_PostEffect_InputTextures[Index] = DrawSurfaceOrTexture;
				DGE.m_PostEffect_InputTextureSubresourceTypes[Index] = SubresourceType;
			}
		} else {
			REPORT_NOT_RUNNING(L"PostEffect_GiveInputSurface")
		}
	)
}

void CDFPGECtrl::PostEffect_GiveInputVector(int Index, float X, float Y, float Z, float W) {
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running) {
			if (Index < 0 || Index > NumberOfUserVectorsPerPostEffect) {
				swprintf_s( MQ->messageBuffer, L"PostEffect_GiveInputVector: Index %i was out of bound [0..%i].",Index,NumberOfUserVectorsPerPostEffect); MQ->InsertMessage(MQ->messageBuffer);
			} else {
				DGE.m_PostEffect_InputArguments[Index].x = X;
				DGE.m_PostEffect_InputArguments[Index].y = Y;
				DGE.m_PostEffect_InputArguments[Index].z = Z;
				DGE.m_PostEffect_InputArguments[Index].w = W;
			}
		} else {
			REPORT_NOT_RUNNING(L"PostEffect_GiveInputVector")
		}
	)
}
