
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

// Read the material shader's filename from the string buffer and load it
int CDFPGECtrl::Shader_LoadAsMaterial_InSB() {
	int Result;
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running == false) {
			REPORT_NOT_RUNNING(L"Shader_LoadAsMaterial_InSB")
			Result = 0;
		} else if (IsSimpleName(StringBuffer) == false) {
			swprintf_s( MQ->messageBuffer, L"Shader_LoadAsMaterial_InSB: The filename in the string buffer may not contain illegal characters. \"%s\" is not an allowed filename in the engine.", StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
			Result = 0;
		} else {
			if (removeExtension(StringBuffer,Filename)) {
				Result = DGE.IDFromPointer(DGE.Shader_Load(Filename,ShaderType_Material,true));
			} else {
				swprintf_s( MQ->messageBuffer, L"Shader_LoadAsMaterial_InSB: The filename in the string buffer was too long. Filename = \"%s\".\n",StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
			}
		}
	)
	return Result;
}

// Read the post effect shader's filename from the string buffer and load it
int CDFPGECtrl::Shader_LoadAsPostEffect_InSB() {
	int Result;
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running == false) {
			REPORT_NOT_RUNNING(L"Shader_LoadAsPostEffect_InSB")
			Result = 0;
		} else if (IsSimpleName(StringBuffer) == false) {
			swprintf_s( MQ->messageBuffer, L"Shader_LoadAsPostEffect_InSB: The filename in the string buffer may not contain illegal characters. \"%s\" is not an allowed filename in the engine.", StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
			Result = 0;
		} else {
			if (removeExtension(StringBuffer,Filename)) {
				Result = DGE.IDFromPointer(DGE.Shader_Load(Filename,ShaderType_PostEffect,true));
			} else {
				swprintf_s( MQ->messageBuffer, L"Shader_LoadAsPostEffect_InSB: The filename in the string buffer was too long. Filename = \"%s\".\n",StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
			}
		}
	)
	return Result;
}

// Read the draw shader's filename from the string buffer and load it
int CDFPGECtrl::Shader_LoadAsDrawShader_InSB() {
	int Result;
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running == false) {
			REPORT_NOT_RUNNING(L"Shader_LoadAsDrawShader_InSB")
			Result = 0;
		} else if (IsSimpleName(StringBuffer) == false) {
			swprintf_s( MQ->messageBuffer, L"Shader_LoadAsDrawShader_InSB: The filename in the string buffer may not contain illegal characters. \"%s\" is not an allowed filename in the engine.", StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
			Result = 0;
		} else {
			if (removeExtension(StringBuffer,Filename)) {
				Result = DGE.IDFromPointer(DGE.Shader_Load(Filename,ShaderType_Draw,true));
			} else {
				swprintf_s( MQ->messageBuffer, L"Shader_LoadAsDrawShader_InSB: The filename in the string buffer was too long. Filename = \"%s\".\n",StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
			}
		}
	)
	return Result;
}

void CDFPGECtrl::Shader_GetFilename_OutSB(int Shader) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(Shader,Shader)
		if BAD_REF(Shader) {
			REPORT_TYPE(Shader,L"Shader_GetFilename_OutSB",Shader)
		} else {
			if (pShader->Locked == false) {
				MQ->InsertMessage(L"Shader_GetFilename_OutSB: The shader is not locked and can be deleted by the engine. Only unlock resources when you are done with using them. Using unlocked resources is as bad as writing to unallocated memory.");
			}
			FillSB(pShader->FileName);
		}
	)
}

void CDFPGECtrl::Shader_Unlock(int Shader) {
	CRITICAL_CODE_SECTION(
		GET_FROM_REF(Shader,Shader)
		if BAD_REF(Shader) {
			REPORT_TYPE(Shader,L"Shader_Unlock",Shader)
		} else {
			if (pShader->Locked == false) {
				MQ->InsertMessage(L"Shader_Unlock: The shader was already unlocked. This call could have unlocked something else and cause errors.");
			}
			pShader->Locked = false;
		}
	)
}

void CDFPGECtrl::Shader_UseAsDefaultMaterialShader(int MaterialShader) {
	CRITICAL_CODE_SECTION(
		if (MaterialShader == 0) {
			DGE.SetDefaultMaterialShader(NULL);
		} else {
			GET_FROM_REF(Shader,MaterialShader)
			if BAD_REF(MaterialShader) {
				REPORT_TYPE(Shader,L"Shader_UseAsDefaultMaterialShader",MaterialShader)
			} else if (pMaterialShader->Compiled == false) {
				MQ->InsertMessage(L"Shader_UseAsDefaultMaterialShader: The shader is not compiled and would therefor be replaced by itself in an infinite loop.");
			} else if (pMaterialShader->ShaderType != ShaderType_Material) {
				MQ->InsertMessage(L"Shader_UseAsDefaultMaterialShader: The shader is a valid shader but not a material shader.");
			} else {
				if (pMaterialShader->Locked == false) {
					MQ->InsertMessage(L"Shader_UseAsDefaultMaterialShader: The shader is not locked and can be deleted by the engine. Only unlock resources when you are done with using them. Using unlocked resources is as bad as writing to unallocated memory.");
				}
				DGE.SetDefaultMaterialShader(pMaterialShader);
			}
		}
	)
}

void CDFPGECtrl::Shader_SetGlobalTime(float NewValue) {
	CRITICAL_CODE_SECTION(
		DGE.m_GlobalTime = NewValue;
	)
}

float CDFPGECtrl::Shader_GetGlobalTime(void) {
	float Result;
	CRITICAL_CODE_SECTION(
		Result = DGE.m_GlobalTime;
	)
	return Result;
}
