
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

// The string buffer should contain the filename to the image.
int CDFPGECtrl::Texture_Load_InSB(void) {
	int Result;
	CRITICAL_CODE_SECTION(
		if (DGE.m_Running == false) {
			REPORT_NOT_RUNNING(L"Texture_Load_InSB")
			Result = 0;
		} else if (IsSimpleName(StringBuffer) == false) {
			swprintf_s( MQ->messageBuffer, L"Texture_Load_InSB: The extensionless filename in the string buffer may not contain illegal characters. \"%s\" is not an allowed filename in the engine.", StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
			Result = 0;
		} else {
			if (removeExtension(StringBuffer,Filename)) {
				Result = DGE.IDFromPointer(DGE.Texture_Load(Filename,true));
			} else {
				swprintf_s( MQ->messageBuffer, L"Texture_Load_InSB: The filename in the string buffer was too long. Filename = \"%s\".\n",StringBuffer); MQ->InsertMessage(MQ->messageBuffer);
			}
		}
	)
	return Result;
}

int CDFPGECtrl::Texture_GetWidth(int Texture) {
	int Result;
	CRITICAL_CODE_SECTION(
		Texture_Struct* pTexture; pTexture = DGE.Texture_PointerFromID(Texture,false);
		if BAD_REF(Texture) {
			REPORT_TYPE(Texture,L"Texture_GetWidth",Texture)
			Result = 0;
		} else {
			if (pTexture->Locked == false) {
				MQ->InsertMessage(L"Texture_GetWidth: The texture is not locked and can be deleted by the engine. Only unlock resources when you are done with using them. Using unlocked resources is as bad as writing to unallocated memory.");
			}
			Result = pTexture->Width;
		}
	)
	return Result;
}

int CDFPGECtrl::Texture_GetHeight(int Texture) {
	int Result;
	CRITICAL_CODE_SECTION(
		Texture_Struct* pTexture; pTexture = DGE.Texture_PointerFromID(Texture,false);
		if BAD_REF(Texture) {
			REPORT_TYPE(Texture,L"Texture_GetHeight",Texture)
			Result = 0;
		} else {
			if (pTexture->Locked == false) {
				MQ->InsertMessage(L"Texture_GetHeight: The texture is not locked and can be deleted by the engine. Only unlock resources when you are done with using them. Using unlocked resources is as bad as writing to unallocated memory.");
			}
			Result = pTexture->Height;
		}
	)
	return Result;
}

void CDFPGECtrl::Texture_GetFilename_OutSB(int Texture) {
	CRITICAL_CODE_SECTION(
		Texture_Struct* pTexture; pTexture = DGE.Texture_PointerFromID(Texture,false);
		if BAD_REF(Texture) {
			REPORT_TYPE(Texture,L"Texture_GetFilename_OutSB",Texture)
		} else {
			if (pTexture->Locked == false) {
				MQ->InsertMessage(L"Texture_GetFilename_OutSB: The texture is not locked and can be deleted by the engine. Only unlock resources when you are done with using them. Using unlocked resources is as bad as writing to unallocated memory.");
			}
			FillSB(pTexture->FileName);
		}
	)
}

void CDFPGECtrl::Texture_Unlock(int Texture) {
	CRITICAL_CODE_SECTION(
		Texture_Struct* pTexture; pTexture = DGE.Texture_PointerFromID(Texture,false);
		if BAD_REF(Texture) {
			REPORT_TYPE(Texture,L"Texture_Unlock",Texture)
		} else {
			if (pTexture->Locked == false) {
				MQ->InsertMessage(L"Texture_Unlock: The texture was already unlocked. This call could have unlocked something else and cause errors.");
			}
			pTexture->Locked = false;
		}
	)
}

void CDFPGECtrl::Texture_UseAsDefaultTexture(int Texture) {
	START_OF_CRITICAL_SECTION
		if (Texture == 0) {
			DGE.SetDefaultTexture(NULL);
		} else {
			Texture_Struct* pTexture; pTexture = DGE.Texture_PointerFromID(Texture,true);
			if BAD_REF(Texture) {
				REPORT_TYPE(Texture,L"Texture_UseAsDefaultTexture",Texture)
			} else {
				if (pTexture->Locked == false) {
					MQ->InsertMessage(L"Texture_UseAsDefaultTexture: The texture is not locked and can be deleted by the engine. Only unlock resources when you are done with using them. Using unlocked resources is as bad as writing to unallocated memory.");
				}
				DGE.SetDefaultTexture(pTexture);
			}
		}
	END_OF_CRITICAL_SECTION
}

void CDFPGECtrl::Texture_UseAsLightProjectionAtlas(int Texture) {
	CRITICAL_CODE_SECTION(
		if (Texture == 0) {
			DGE.SetLightProjectionAtlas(NULL);
		} else {
			Texture_Struct* pTexture; pTexture = DGE.Texture_PointerFromID(Texture,true);
			if BAD_REF(Texture) {
				REPORT_TYPE(Texture,L"Texture_UseAsLightProjectionAtlas",Texture)
			} else {
				if (pTexture->Locked == false) {
					MQ->InsertMessage(L"Texture_UseAsLightProjectionAtlas: The texture is not locked and can be deleted by the engine. Only unlock resources when you are done with using them. Using unlocked resources is as bad as writing to unallocated memory.");
				}
				DGE.SetLightProjectionAtlas(pTexture);
			}
		}
	)
}
