
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#include "stdafx.h"
#include "MessageQueue.h"

MessageQueue::MessageQueue(void) {
	int i;
	MessageCount = 0;
	LoopForwardLengthFromZero(i,16384) {
		messageBuffer[i] = 0;
	}
	LoopForwardLengthFromZero(i,32) {
		MessageArray[i].Text = NULL;
	}
}

MessageQueue::~MessageQueue(void) {
	EraseMessages();
}

void MessageQueue::EraseMessages(void) {
	int i;
	LoopForwardLengthFromZero(i,32) {
		if (MessageArray[i].Text != NULL) {
			SAFE_DELETE_ARRAY(MessageArray[i].Text)
		}
	}
	MessageCount = 0;
}

void MessageQueue::InsertMessage(wchar_t* Message) {
	if (MessageCount < 32) {
		printf("Queue: Inserted message\n");
		
		// Safely delete any old string
		SAFE_DELETE(MessageArray[MessageCount].Text)
		
		// Make a new string
		MessageArray[MessageCount].Text = CopyToNewString(Message);
		
		MessageCount++;
	}
}

wchar_t* MessageQueue::GetTextFromFirstMessage(void) {
	if (MessageCount > 0) {
		return MessageArray[0].Text;
	} else {
		return NULL;
	}
}

void MessageQueue::DeleteFirstMessage(void) {
	if (MessageCount > 0) {
		int i;
		LoopForward(0,i,MessageCount-2) {
			MessageArray[i] = MessageArray[i + 1];
		}
		MessageArray[MessageCount-1].Text = NULL;
		MessageCount--;
	}
}
