
// zlib open source license
//
// Copyright (c) 2010 to 2013 David Forsgren Piuva
// 
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
// 
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 
//    1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 
//    2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 
//    3. This notice may not be removed or altered from any source
//    distribution.

#pragma once

struct Message {
	wchar_t* Text;
};

class MessageQueue {
public:
	MessageQueue(void);
	~MessageQueue(void);
	
	// The number of stored messages
	int MessageCount;
	
	// Memory used by callers for generating messages
	wchar_t messageBuffer[16384];
	
	// The list of messages
	Message MessageArray[32];
	
	// Inserts Message to the queue if it is not full
	void InsertMessage(wchar_t* Message);
	
	// Returns NULL if there are no new messages
	// Returns a pointer to a string from the queue
	wchar_t* GetTextFromFirstMessage(void);
	
	// Removes the first message
	void DeleteFirstMessage(void);
	
	// Erases all stored message strings
	void EraseMessages(void);
};
